/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.net;

import ca.nrc.cadc.auth.NotAuthenticatedException;
import ca.nrc.cadc.io.ByteLimitExceededException;
import ca.nrc.cadc.net.ExpectationFailedException;
import ca.nrc.cadc.net.FileContent;
import ca.nrc.cadc.net.HttpTransfer;
import ca.nrc.cadc.net.InputStreamWrapper;
import ca.nrc.cadc.net.PreconditionFailedException;
import ca.nrc.cadc.net.RangeNotSatisfiableException;
import ca.nrc.cadc.net.ResourceAlreadyExistsException;
import ca.nrc.cadc.net.ResourceNotFoundException;
import ca.nrc.cadc.net.TransientException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import org.apache.log4j.Logger;

public class HttpPost
extends HttpTransfer {
    private static Logger log = Logger.getLogger(HttpPost.class);
    private static final String MULTIPART_BOUNDARY = UUID.randomUUID().toString();
    private static final String LINE_FEED = "\r\n";
    private final Map<String, Object> paramMap = new TreeMap<String, Object>();
    private FileContent inputFileContent;

    public HttpPost(URL url, Map<String, Object> map, OutputStream outputStream) {
        super(url, true);
        if (map != null) {
            this.paramMap.putAll(map);
        }
        this.paramMap.putAll(map);
        this.responseDestination = outputStream;
    }

    public HttpPost(URL url, Map<String, Object> map, InputStreamWrapper istreamWrapper) {
        this(url, map, true);
        this.responseStreamWrapper = istreamWrapper;
    }

    public HttpPost(URL url, Map<String, Object> map, boolean followRedirects) {
        super(url, followRedirects);
        if (map != null) {
            this.paramMap.putAll(map);
        }
    }

    public HttpPost(URL url, FileContent input, boolean followRedirects) {
        super(url, followRedirects);
        this.inputFileContent = input;
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null");
        }
    }

    @Deprecated
    public HttpPost(URL url, String content, String contentType, boolean followRedirects) {
        this(url, new FileContent(content, contentType, Charset.forName("UTF-8")), followRedirects);
    }

    public Map<String, Object> getParameterMap() {
        return this.paramMap;
    }

    public String toString() {
        return "HttpPost[" + this.remoteURL + "]";
    }

    @Deprecated
    public String getResponseContentEncoding() {
        return this.getResponseHeader("Content-Encoding");
    }

    @Deprecated
    public String getResponseContentType() {
        return this.getResponseHeader("Content-Type");
    }

    @Deprecated
    public String getResponseBody() throws IOException {
        try {
            if (this.responseStream != null) {
                return this.readResponseBody(this.responseStream);
            }
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("read interrupted", ex);
        }
        return null;
    }

    @Override
    public void prepare() throws AccessControlException, NotAuthenticatedException, ByteLimitExceededException, ExpectationFailedException, IllegalArgumentException, PreconditionFailedException, ResourceAlreadyExistsException, ResourceNotFoundException, TransientException, IOException, InterruptedException, RangeNotSatisfiableException {
        this.doActionWithRetryLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doAction() throws AccessControlException, NotAuthenticatedException, ByteLimitExceededException, ExpectationFailedException, IllegalArgumentException, PreconditionFailedException, ResourceAlreadyExistsException, ResourceNotFoundException, TransientException, IOException, InterruptedException, RangeNotSatisfiableException {
        log.debug((Object)this.toString());
        try {
            this.thread = Thread.currentThread();
            HttpURLConnection conn = (HttpURLConnection)this.remoteURL.openConnection();
            super.setRequestOptions(conn);
            conn.setRequestMethod("POST");
            this.setRequestAuthHeaders(conn);
            if (conn instanceof HttpsURLConnection) {
                HttpsURLConnection sslConn = (HttpsURLConnection)conn;
                this.initHTTPS(sslConn);
            }
            this.doPost(conn);
            this.responseStream = conn.getInputStream();
        }
        finally {
            if (this.responseDestination != null) {
                log.debug((Object)"closing OutputStream");
                try {
                    this.responseDestination.close();
                }
                catch (Exception exception) {}
            }
            HttpPost httpPost = this;
            synchronized (httpPost) {
                if (this.thread != null) {
                    if (Thread.interrupted()) {
                        this.go = false;
                    }
                    this.thread = null;
                }
            }
        }
    }

    private void doPost(HttpURLConnection conn) throws AccessControlException, NotAuthenticatedException, ByteLimitExceededException, ExpectationFailedException, IllegalArgumentException, PreconditionFailedException, ResourceAlreadyExistsException, ResourceNotFoundException, TransientException, IOException, InterruptedException, RangeNotSatisfiableException {
        if (this.inputFileContent != null) {
            this.doPost(conn, this.inputFileContent);
        } else {
            TreeMap<String, List<Object>> pmap = new TreeMap<String, List<Object>>();
            TreeMap<String, Object> uploads = new TreeMap<String, Object>();
            for (Map.Entry<String, Object> me : this.paramMap.entrySet()) {
                String key = me.getKey();
                Object value = me.getValue();
                if (value instanceof File) {
                    File u = (File)value;
                    uploads.put(key, u);
                    continue;
                }
                if (value instanceof FileContent) {
                    FileContent fc = (FileContent)value;
                    uploads.put(key, fc);
                    continue;
                }
                if (value instanceof Collection) {
                    Collection vals = (Collection)value;
                    ArrayList pmv = new ArrayList(vals.size());
                    pmv.addAll(vals);
                    pmap.put(key, pmv);
                    continue;
                }
                ArrayList<Object> pmv = new ArrayList<Object>(1);
                pmv.add(value);
                pmap.put(key, pmv);
            }
            this.doPost(conn, pmap, uploads);
        }
        this.checkErrors(this.remoteURL, conn);
        this.checkRedirects(this.remoteURL, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPost(HttpURLConnection conn, FileContent input) throws AccessControlException, NotAuthenticatedException, ByteLimitExceededException, ExpectationFailedException, IllegalArgumentException, PreconditionFailedException, ResourceAlreadyExistsException, ResourceNotFoundException, TransientException, IOException, InterruptedException {
        byte[] buf = input.getBytes();
        String len = Long.toString(buf.length);
        this.setRequestProperty("Content-Length", len);
        this.setRequestProperty("Content-Type", input.getContentType());
        this.setRequestHeaders(conn);
        conn.setInstanceFollowRedirects(this.followRedirects);
        conn.setUseCaches(false);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        OutputStream ostream = conn.getOutputStream();
        try {
            ostream.write(input.getBytes());
        }
        finally {
            ostream.flush();
            ostream.close();
        }
        log.debug((Object)("POST - send done: " + this.remoteURL.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void doPost(HttpURLConnection conn, Map<String, List<Object>> params, Map<String, Object> uploads) throws AccessControlException, NotAuthenticatedException, ByteLimitExceededException, ExpectationFailedException, IllegalArgumentException, PreconditionFailedException, ResourceAlreadyExistsException, ResourceNotFoundException, TransientException, IOException, InterruptedException {
        String ctype = "application/x-www-form-urlencoded";
        boolean multi = false;
        if (!uploads.isEmpty()) {
            ctype = "multipart/form-data; boundary=" + MULTIPART_BOUNDARY;
            multi = true;
        }
        if (ctype != null) {
            conn.setRequestProperty("Content-Type", ctype);
        }
        log.debug((Object)("POST Content-Type: " + ctype));
        this.setRequestHeaders(conn);
        conn.setInstanceFollowRedirects(this.followRedirects);
        conn.setUseCaches(false);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<Object>> pe : params.entrySet()) {
            for (Object object : pe.getValue()) {
                void var10_10;
                if (multi) {
                    sb.append(LINE_FEED).append("--" + MULTIPART_BOUNDARY);
                    sb.append(LINE_FEED).append("Content-Disposition: form-data; name=\"").append(pe.getKey()).append("\"");
                    sb.append(LINE_FEED);
                    sb.append(LINE_FEED).append(object.toString());
                    continue;
                }
                sb.append(pe.getKey());
                sb.append("=");
                if (object instanceof char[]) {
                    String string = String.valueOf((char[])object);
                }
                sb.append(URLEncoder.encode(var10_10.toString(), "UTF-8"));
                sb.append("&");
            }
        }
        log.debug((Object)("params: " + sb.toString()));
        Charset utf8 = Charset.forName("UTF-8");
        OutputStream writer = conn.getOutputStream();
        try {
            writer.write(sb.toString().getBytes(utf8));
            if (multi) {
                for (Map.Entry entry : uploads.entrySet()) {
                    if (entry.getValue() instanceof File) {
                        this.writeFilePart((String)entry.getKey(), (File)entry.getValue(), writer, utf8);
                        continue;
                    }
                    if (entry.getValue() instanceof FileContent) {
                        this.writeFilePart((String)entry.getKey(), (FileContent)entry.getValue(), writer, utf8);
                        continue;
                    }
                    throw new UnsupportedOperationException("Unexpected upload type: " + entry.getClass().getName());
                }
                String end = "\r\n--" + MULTIPART_BOUNDARY + "--" + LINE_FEED;
                writer.write(end.getBytes(utf8));
            }
        }
        finally {
            writer.flush();
            writer.close();
        }
        log.debug((Object)("POST - send done: " + this.remoteURL.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFilePart(String fieldName, File uploadFile, OutputStream w, Charset utf8) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(LINE_FEED).append("--" + MULTIPART_BOUNDARY);
        sb.append(LINE_FEED).append("Content-Disposition: form-data; name=\"").append(fieldName).append("\";").append(" filename=\"").append(uploadFile.getName()).append("\"");
        sb.append(LINE_FEED);
        sb.append(LINE_FEED);
        log.debug((Object)("MULTIPART PORTION: " + sb.toString()));
        w.write(sb.toString().getBytes(utf8));
        long len = 0L;
        try (FileInputStream r = null;){
            int bytesRead;
            r = new FileInputStream(uploadFile);
            byte[] buffer = new byte[4096];
            while ((bytesRead = r.read(buffer)) != -1) {
                w.write(buffer, 0, bytesRead);
                len += (long)bytesRead;
            }
        }
        log.debug((Object)("file part length: " + len));
    }

    private void writeFilePart(String fieldName, FileContent uploadContent, OutputStream w, Charset utf8) throws IOException {
        StringBuilder sb = new StringBuilder();
        log.debug((Object)("writeFilePart: " + uploadContent.getContentType()));
        sb.append(LINE_FEED).append("--").append(MULTIPART_BOUNDARY);
        sb.append(LINE_FEED).append("Content-Disposition: form-data; name=\"").append(fieldName).append("\";").append(" filename=\"dummyFile\"");
        if (uploadContent.getContentType() != null) {
            sb.append(LINE_FEED).append("Content-Type").append(": ").append(uploadContent.getContentType());
        }
        sb.append(LINE_FEED);
        sb.append(LINE_FEED);
        log.debug((Object)("MULTIPART PORTION: " + sb.toString()));
        w.write(sb.toString().getBytes(utf8));
        w.write(uploadContent.getBytes());
        w.flush();
    }
}

