/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.net;

import ca.nrc.cadc.auth.AuthorizationToken;
import ca.nrc.cadc.auth.NotAuthenticatedException;
import ca.nrc.cadc.auth.SSLUtil;
import ca.nrc.cadc.auth.SSOCookieCredential;
import ca.nrc.cadc.io.ByteCountInputStream;
import ca.nrc.cadc.io.ByteLimitExceededException;
import ca.nrc.cadc.net.DigestUtil;
import ca.nrc.cadc.net.ExpectationFailedException;
import ca.nrc.cadc.net.HttpRequestProperty;
import ca.nrc.cadc.net.IncorrectContentChecksumException;
import ca.nrc.cadc.net.InputStreamWrapper;
import ca.nrc.cadc.net.PreconditionFailedException;
import ca.nrc.cadc.net.RangeNotSatisfiableException;
import ca.nrc.cadc.net.RemoteServiceException;
import ca.nrc.cadc.net.ResourceAlreadyExistsException;
import ca.nrc.cadc.net.ResourceLockedException;
import ca.nrc.cadc.net.ResourceNotFoundException;
import ca.nrc.cadc.net.TransientException;
import ca.nrc.cadc.net.event.ProgressListener;
import ca.nrc.cadc.net.event.TransferEvent;
import ca.nrc.cadc.net.event.TransferListener;
import ca.nrc.cadc.util.CaseInsensitiveStringComparator;
import ca.nrc.cadc.util.FileMetadata;
import ca.nrc.cadc.util.HexUtil;
import ca.nrc.cadc.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;

public abstract class HttpTransfer
implements Runnable {
    private static Logger log = Logger.getLogger(HttpTransfer.class);
    static final int HTTP_RANGE_NOT_SATISFIABLE = 416;
    static final int HTTP_EXPECT_FAIL = 417;
    static final int HTTP_LOCKED = 423;
    public static final String DEFAULT_USER_AGENT;
    public static final String CADC_CONTENT_LENGTH_HEADER = "X-CADC-Content-Length";
    public static final String CADC_STREAM_HEADER = "X-CADC-Stream";
    public static final String CADC_PARTIAL_READ_HEADER = "X-CADC-Partial-Read";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_MD5 = "Content-MD5";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String DIGEST = "Digest";
    public static final String SERVICE_RETRY = "Retry-After";
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    protected int connectionTimeout = 0;
    protected int readTimeout = 0;
    public static final int MAX_RETRY_DELAY = 128;
    public static final int DEFAULT_RETRY_DELAY = 30;
    protected int maxRetries = 3;
    protected int retryDelay = 1;
    protected RetryReason retryReason = RetryReason.TRANSIENT;
    protected int numRetries = 0;
    protected int curRetryDelay = 0;
    protected int bufferSize = 8192;
    protected ProgressListener progressListener;
    protected TransferListener transferListener;
    protected boolean fireEvents = false;
    protected boolean fireCancelOnce = true;
    protected File localFile;
    public String eventID = null;
    protected String userAgent;
    protected boolean userNio = false;
    protected boolean logIO = false;
    protected long writeTime = 0L;
    protected long readTime = 0L;
    protected boolean go;
    protected Thread thread;
    protected final URL remoteURL;
    protected boolean followRedirects;
    public Throwable failure;
    protected URL redirectURL;
    protected int responseCode = -1;
    protected boolean prepareStream;
    protected Long requestStartTime;
    protected Long responseLatency;
    private boolean customSSLSocketFactory = false;
    private final List<HttpRequestProperty> requestProperties = new ArrayList<HttpRequestProperty>();
    private final Map<String, String> responseHeaders = new TreeMap<String, String>(new CaseInsensitiveStringComparator());
    private final Map<String, List<String>> responseHeadersMulti = new TreeMap<String, List<String>>(new CaseInsensitiveStringComparator());
    protected InputStream responseStream;
    private String contentType;
    private String contentEncoding;
    private String contentMD5;
    private long contentLength = -1L;
    private Date lastModified;
    private String digest;
    protected int maxReadFully = 32768;
    protected OutputStream responseDestination;
    protected InputStreamWrapper responseStreamWrapper;

    protected final void assertNotNull(String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
    }

    protected HttpTransfer(URL url, boolean followRedirects) {
        this.assertNotNull("url", url);
        this.remoteURL = url;
        this.followRedirects = followRedirects;
        this.go = true;
        this.userAgent = DEFAULT_USER_AGENT;
        String bsize = null;
        try {
            bsize = System.getProperty(HttpTransfer.class.getName() + ".bufferSize");
            if (bsize != null) {
                int mult = 1;
                String sz = bsize;
                if ((bsize = bsize.trim()).endsWith("k")) {
                    mult = 1024;
                    sz = bsize.substring(0, bsize.length() - 1);
                } else if (bsize.endsWith("m")) {
                    mult = 0x100000;
                    sz = bsize.substring(0, bsize.length() - 1);
                }
                this.bufferSize = mult * Integer.parseInt(sz);
            }
        }
        catch (NumberFormatException warn) {
            log.warn((Object)("invalid buffer size: " + bsize + ", using default " + 8192));
            this.bufferSize = 8192;
        }
        log.debug((Object)("bufferSize: " + this.bufferSize));
    }

    public abstract void prepare() throws AccessControlException, NotAuthenticatedException, ByteLimitExceededException, ExpectationFailedException, IllegalArgumentException, PreconditionFailedException, ResourceAlreadyExistsException, ResourceNotFoundException, TransientException, IOException, InterruptedException, RangeNotSatisfiableException;

    protected void doActionWithRetryLoop() throws AccessControlException, NotAuthenticatedException, ByteLimitExceededException, ExpectationFailedException, IllegalArgumentException, PreconditionFailedException, ResourceAlreadyExistsException, ResourceNotFoundException, TransientException, IOException, InterruptedException, RangeNotSatisfiableException {
        boolean done = false;
        while (!done) {
            try {
                this.doAction();
                done = true;
            }
            catch (TransientException ex) {
                try {
                    long dt = 1000L * (long)ex.getRetryDelay();
                    if (this.numRetries >= this.maxRetries) {
                        log.debug((Object)"retry limit reached");
                        throw ex;
                    }
                    ++this.numRetries;
                    log.debug((Object)("retry " + this.numRetries + " sleeping  for " + dt));
                    Thread.sleep(dt);
                    this.fireEvent(9);
                }
                catch (InterruptedException iex) {
                    this.fireEvent(6);
                    done = true;
                }
            }
        }
    }

    protected void doAction() throws AccessControlException, NotAuthenticatedException, ByteLimitExceededException, ExpectationFailedException, IllegalArgumentException, PreconditionFailedException, ResourceAlreadyExistsException, ResourceNotFoundException, TransientException, IOException, InterruptedException, RangeNotSatisfiableException {
    }

    @Override
    public void run() {
        if (this.failure == null) {
            try {
                if (this.responseStream == null) {
                    this.prepare();
                }
                this.readResponse(this.responseStream);
            }
            catch (Throwable t) {
                this.failure = t;
            }
        }
    }

    public InputStream getInputStream() {
        return this.responseStream;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getContentMD5() {
        return this.contentMD5;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public URI getDigest() {
        if (this.digest == null) {
            return null;
        }
        return DigestUtil.getURI(this.digest);
    }

    public Long getResponceLatency() {
        return this.responseLatency;
    }

    public String getResponseHeader(String key) {
        return this.responseHeaders.get(key);
    }

    public List<String> getResponseHeaderValues(String key) {
        List<String> ret = this.responseHeadersMulti.get(key);
        if (ret == null) {
            ret = new ArrayList<String>(0);
        }
        return ret;
    }

    private void captureResponseHeaders(HttpURLConnection con) {
        this.responseHeaders.clear();
        this.responseHeadersMulti.clear();
        Map<String, List<String>> hdrs = con.getHeaderFields();
        for (Map.Entry<String, List<String>> me : hdrs.entrySet()) {
            if (me.getKey() == null) continue;
            this.responseHeadersMulti.put(me.getKey(), me.getValue());
            if (me.getValue().size() != 1) continue;
            this.responseHeaders.put(me.getKey(), me.getValue().get(0));
        }
        this.contentType = this.responseHeaders.get(CONTENT_TYPE);
        this.contentEncoding = this.responseHeaders.get(CONTENT_ENCODING);
        this.contentMD5 = this.responseHeaders.get(CONTENT_MD5);
        this.contentLength = con.getContentLengthLong();
        long lastMod = con.getLastModified();
        if (lastMod > 0L) {
            this.lastModified = new Date(lastMod);
        }
        this.digest = this.responseHeaders.get(DIGEST);
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public URL getRedirectURL() {
        return this.redirectURL;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setRetry(int maxRetries, int retryDelay, RetryReason reason) {
        this.maxRetries = maxRetries;
        this.retryDelay = retryDelay;
        this.retryReason = reason;
    }

    public URL getURL() {
        return this.remoteURL;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public final void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        if (userAgent == null) {
            this.userAgent = DEFAULT_USER_AGENT;
        }
    }

    public void setLogIO(boolean logIO) {
        this.logIO = logIO;
    }

    public Long getIOReadTime() {
        if (this.logIO) {
            return this.readTime;
        }
        return null;
    }

    public Long getIOWriteTime() {
        if (this.logIO) {
            return this.writeTime;
        }
        return null;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setDigest(URI checksumURI) {
        if (checksumURI != null) {
            String val = DigestUtil.toDigest(checksumURI);
            this.setRequestProperty(DIGEST, val);
        }
    }

    public void setRequestProperty(String header, String value) {
        this.requestProperties.add(new HttpRequestProperty(header, value));
    }

    public void setRequestProperties(List<HttpRequestProperty> props) {
        if (props != null) {
            log.debug((Object)("add request properties: " + props.size()));
            this.requestProperties.addAll(props);
        }
    }

    public List<HttpRequestProperty> getRequestProperties() {
        return this.requestProperties;
    }

    public void setProgressListener(ProgressListener listener) {
        this.progressListener = listener;
        this.fireEvents = this.progressListener != null || this.transferListener != null;
    }

    public void setTransferListener(TransferListener listener) {
        this.transferListener = listener;
        this.fireEvents = this.progressListener != null || this.transferListener != null;
    }

    public int getRetriesPerformed() {
        return this.numRetries;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public Throwable getThrowable() {
        return this.failure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this.fireEvents = false;
        this.go = false;
        HttpTransfer httpTransfer = this;
        synchronized (httpTransfer) {
            if (this.thread != null) {
                log.debug((Object)("terminate(): interrupting " + this.thread.getName()));
                try {
                    this.thread.interrupt();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        this.fireCancelledEvent();
        this.fireCancelOnce = false;
    }

    protected final void setRequestOptions(HttpURLConnection conn) {
        conn.setConnectTimeout(this.connectionTimeout);
        conn.setReadTimeout(this.readTimeout);
    }

    protected void checkTransient(int code, String msg, HttpURLConnection conn) throws TransientException {
        if (RetryReason.NONE.equals((Object)this.retryReason)) {
            return;
        }
        boolean trans = false;
        int dt = 0;
        if (code == 503) {
            if (!StringUtil.hasText(msg)) {
                msg = "server busy";
            }
            String retryAfter = this.responseHeaders.get(SERVICE_RETRY);
            log.debug((Object)("got 503 with Retry-After: " + retryAfter));
            if (StringUtil.hasText(retryAfter)) {
                try {
                    dt = Integer.parseInt(retryAfter);
                    trans = true;
                    if (dt > 128) {
                        dt = 128;
                    }
                }
                catch (NumberFormatException nex) {
                    log.warn((Object)("Retry-After after a 503 was not a number: " + retryAfter + ", ignoring"));
                }
            }
        }
        if (RetryReason.TRANSIENT.equals((Object)this.retryReason)) {
            switch (code) {
                case 402: 
                case 408: 
                case 503: 
                case 504: {
                    trans = true;
                    break;
                }
            }
        }
        if (RetryReason.ALL.equals((Object)this.retryReason)) {
            trans = true;
        }
        if (trans) {
            if (dt == 0) {
                if (this.curRetryDelay == 0) {
                    this.curRetryDelay = this.retryDelay;
                }
                if (this.curRetryDelay > 0) {
                    dt = this.curRetryDelay;
                    this.curRetryDelay *= 2;
                } else {
                    dt = 30;
                }
            }
            throw new TransientException(msg.trim(), dt);
        }
    }

    protected void checkErrors(URL url, HttpURLConnection conn) throws AccessControlException, NotAuthenticatedException, ByteLimitExceededException, ExpectationFailedException, IllegalArgumentException, PreconditionFailedException, ResourceAlreadyExistsException, ResourceNotFoundException, TransientException, IOException, InterruptedException, RangeNotSatisfiableException {
        try {
            this.responseCode = conn.getResponseCode();
            log.debug((Object)("checkErrors: " + this.responseCode + " for " + url));
            this.captureResponseHeaders(conn);
        }
        catch (SocketTimeoutException ex) {
            int timeoutRetryDelay = 30;
            if (this.connectionTimeout > 0 || this.readTimeout > 0) {
                timeoutRetryDelay = Math.max(this.connectionTimeout, this.readTimeout) / 1000;
            }
            throw new TransientException("connection/read timeout: " + url, ex, timeoutRetryDelay);
        }
        if (100 <= this.responseCode && this.responseCode < 400) {
            return;
        }
        log.debug((Object)("error: " + this.contentType + " " + this.contentLength));
        String responseBody = this.readErrorFromResponseBody(conn);
        log.debug((Object)("error: " + this.contentType + " " + this.contentLength + " response.length: " + responseBody.length()));
        this.checkTransient(this.responseCode, responseBody, conn);
        switch (this.responseCode) {
            case 400: {
                throw new IllegalArgumentException(responseBody);
            }
            case -1: {
                if (this.customSSLSocketFactory) {
                    throw new NotAuthenticatedException(responseBody);
                }
                throw new IOException(responseBody);
            }
            case 401: {
                throw new NotAuthenticatedException(responseBody);
            }
            case 403: {
                throw new AccessControlException(responseBody);
            }
            case 423: {
                throw new ResourceLockedException(responseBody);
            }
            case 404: {
                throw new ResourceNotFoundException(responseBody);
            }
            case 409: {
                throw new ResourceAlreadyExistsException(responseBody);
            }
            case 412: {
                throw new PreconditionFailedException(responseBody);
            }
            case 413: {
                throw new ByteLimitExceededException(responseBody, -1L);
            }
            case 416: {
                throw new RangeNotSatisfiableException(responseBody);
            }
            case 417: {
                throw new ExpectationFailedException(responseBody);
            }
            case 500: {
                String loggableURL = HttpTransfer.toLoggableString(url);
                throw new RemoteServiceException("url=" + loggableURL + " msg=" + responseBody);
            }
            case 503: {
                throw new TransientException(responseBody);
            }
        }
        throw new IOException(responseBody);
    }

    static String toLoggableString(URL url) {
        try {
            StringBuilder sb = new StringBuilder();
            String surl = url.toExternalForm();
            String server = url.getHost();
            int i = surl.indexOf(server);
            int j = surl.indexOf("/", i);
            if (j == -1) {
                return surl;
            }
            String base = surl.substring(0, j);
            log.debug((Object)("base: " + base));
            sb.append(base);
            String path = url.getPath();
            path = path.substring(1);
            String[] ss = path.split("/");
            log.debug((Object)("path: " + path + " " + ss.length));
            if (ss.length > 0) {
                sb.append("/").append(ss[0]);
            }
            if (ss.length > 1) {
                sb.append("/").append(ss[1]);
            }
            if (ss.length > 2) {
                sb.append("/...");
            } else {
                boolean trailingSlash = path.endsWith("/");
                if (trailingSlash) {
                    sb.append("/");
                }
            }
            String query = url.getQuery();
            if (query != null && !query.isEmpty()) {
                sb.append("?...");
            }
            return sb.toString();
        }
        catch (Exception oops) {
            return "to-loggable-failed-bug";
        }
    }

    protected void checkRedirects(URL url, HttpURLConnection conn) throws ResourceNotFoundException, IOException {
        String location = conn.getHeaderField("Location");
        switch (this.responseCode) {
            case 302: 
            case 303: {
                if (location == null) {
                    throw new RuntimeException("incomplete server response: status " + this.responseCode + " with Location: null");
                }
                this.redirectURL = new URL(location);
                log.debug((Object)("redirectURL: " + this.redirectURL));
                return;
            }
            case 301: {
                if (location == null) {
                    throw new ResourceNotFoundException("resource " + url + " moved permanently; Location: null");
                }
                this.redirectURL = new URL(location);
                log.debug((Object)("redirectURL: " + this.redirectURL));
                return;
            }
        }
    }

    protected void findEventID(HttpURLConnection conn) {
        String eventHeader = null;
        if (this.transferListener != null) {
            eventHeader = this.transferListener.getEventHeader();
        }
        if (eventHeader != null) {
            this.eventID = conn.getHeaderField(eventHeader);
        }
    }

    private void fireCancelledEvent() {
        if (this.fireCancelOnce) {
            TransferEvent e = new TransferEvent((Object)this, this.eventID, this.remoteURL, this.localFile, 6);
            this.fireEvent(e);
        }
    }

    private void fireEvent(TransferEvent e) {
        log.debug((Object)("fireEvent: " + e));
        if (this.transferListener != null) {
            this.transferListener.transferEvent(e);
        }
        if (this.progressListener != null) {
            this.progressListener.transferEvent(e);
        }
    }

    protected void fireEvent(int state) {
        this.fireEvent(this.localFile, state);
    }

    protected void fireEvent(File file, int state) {
        this.fireEvent(file, state, null);
    }

    protected void fireEvent(File file, int state, FileMetadata meta) {
        if (this.fireEvents) {
            TransferEvent e = new TransferEvent((Object)this, this.eventID, this.remoteURL, file, state);
            e.setFileMetadata(meta);
            this.fireEvent(e);
        }
    }

    protected void fireEvent(Throwable t) {
        this.fireEvent(this.localFile, t);
    }

    protected void fireEvent(File file, Throwable t) {
        if (this.fireEvents) {
            TransferEvent e = new TransferEvent((Object)this, this.eventID, this.remoteURL, file, t);
            this.fireEvent(e);
        }
    }

    protected void initHTTPS(HttpsURLConnection sslConn) {
        this.customSSLSocketFactory = false;
        log.debug((Object)"initHTTPS: lazy init");
        AccessControlContext ac = AccessController.getContext();
        Subject s = Subject.getSubject(ac);
        SSLSocketFactory sf = SSLUtil.getSocketFactory(s);
        if (sf != null) {
            log.debug((Object)("setting SSLSocketFactory on " + sslConn.getClass().getName()));
            sslConn.setSSLSocketFactory(sf);
            this.customSSLSocketFactory = true;
        }
    }

    protected String ioLoop(InputStream istream, OutputStream ostream, int sz, long startingPos) throws IOException, InterruptedException {
        log.debug((Object)("ioLoop: using java.io with byte[] buffer size " + sz + " startingPos " + startingPos));
        long readStart = 0L;
        long writeStart = 0L;
        byte[] buf = new byte[sz];
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException oops) {
            log.warn((Object)("failed to create MessageDigest(MD5): " + oops));
        }
        int nb = 0;
        int nb2 = 0;
        long tot = startingPos;
        boolean n = false;
        if (this.progressListener != null) {
            this.progressListener.update(0L, tot);
        }
        while (nb != -1) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.logIO) {
                readStart = System.currentTimeMillis();
            }
            nb = istream.read(buf, 0, sz);
            if (this.logIO) {
                this.readTime += System.currentTimeMillis() - readStart;
            }
            if (this.requestStartTime != null) {
                this.responseLatency = System.currentTimeMillis() - this.requestStartTime;
            }
            if (nb == -1) continue;
            if (nb < sz / 2) {
                if (this.logIO) {
                    readStart = System.currentTimeMillis();
                }
                nb2 = istream.read(buf, nb, sz - nb);
                if (this.logIO) {
                    this.readTime += System.currentTimeMillis() - readStart;
                }
                if (nb2 > 0) {
                    nb += nb2;
                }
            }
            if (md5 != null) {
                md5.update(buf, 0, nb);
            }
            if (this.logIO) {
                writeStart = System.currentTimeMillis();
            }
            ostream.write(buf, 0, nb);
            if (this.logIO) {
                this.writeTime += System.currentTimeMillis() - writeStart;
            }
            tot += (long)nb;
            if (this.progressListener == null) continue;
            this.progressListener.update(nb, tot);
        }
        if (md5 != null) {
            byte[] md5sum = md5.digest();
            String ret = HexUtil.toHex(md5sum);
            return ret;
        }
        return null;
    }

    protected void nioLoop(InputStream istream, OutputStream ostream, int sz, long startingPos) throws IOException, InterruptedException {
        log.debug((Object)("[Download] nioLoop: using java.nio with ByteBuffer size " + sz));
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException oops) {
            log.warn((Object)("failed to create MessageDigest(MD5): " + oops));
        }
        ReadableByteChannel rbc = Channels.newChannel(istream);
        WritableByteChannel wbc = Channels.newChannel(ostream);
        long tot = startingPos;
        int count = 0;
        ByteBuffer buffer = ByteBuffer.allocate(sz);
        if (this.progressListener != null) {
            this.progressListener.update(count, tot);
        }
        while (count != -1) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            count = rbc.read(buffer);
            if (count == -1) continue;
            wbc.write(buffer.flip());
            buffer.flip();
            tot += (long)count;
            if (this.progressListener == null) continue;
            this.progressListener.update(count, tot);
        }
    }

    protected void setRequestAuthHeaders(HttpURLConnection conn) {
        AccessControlContext acc = AccessController.getContext();
        Subject subj = Subject.getSubject(acc);
        if (subj != null) {
            Set<SSOCookieCredential> cookieCreds;
            Set<AuthorizationToken> tokens = subj.getPublicCredentials(AuthorizationToken.class);
            if (tokens != null && !tokens.isEmpty()) {
                block0: for (AuthorizationToken next : tokens) {
                    log.debug((Object)("Evaluating token: " + next));
                    for (String domain : next.getDomains()) {
                        if (!conn.getURL().getHost().endsWith(domain)) continue;
                        log.debug((Object)("Setting Authorization header for: " + next));
                        conn.setRequestProperty("Authorization", next.getType() + " " + next.getCredentials());
                        continue block0;
                    }
                }
            }
            if ((cookieCreds = subj.getPublicCredentials(SSOCookieCredential.class)) != null && cookieCreds.size() > 0) {
                boolean found = false;
                for (SSOCookieCredential cookieCred : cookieCreds) {
                    if (!conn.getURL().getHost().endsWith(cookieCred.getDomain())) continue;
                    if (this.followRedirects && "POST".equals(conn.getRequestMethod())) {
                        throw new UnsupportedOperationException("Attempt to follow redirect with cookies (POST).");
                    }
                    String cval = "CADC_SSO=\"" + cookieCred.getSsoCookieValue() + "\"";
                    conn.setRequestProperty("Cookie", cval);
                    log.debug((Object)("setRequestSSOCookie: " + cval));
                    found = true;
                    break;
                }
                if (!found) {
                    log.debug((Object)("setRequestSSOCookie: no cookie for domain: " + conn.getURL().getHost()));
                }
            } else {
                log.debug((Object)"setRequestSSOCookie: no cookie");
            }
        }
    }

    protected void setRequestHeaders(HttpURLConnection conn) {
        log.debug((Object)("custom request properties: " + this.requestProperties.size()));
        boolean doChunked = false;
        if (conn.getDoOutput()) {
            doChunked = true;
        }
        for (HttpRequestProperty rp : this.requestProperties) {
            String p = rp.getProperty();
            String v = rp.getValue();
            log.debug((Object)("set request property: " + p + "=" + v));
            if (CONTENT_LENGTH.equalsIgnoreCase(p)) {
                try {
                    long len = Long.parseLong(v);
                    conn.setFixedLengthStreamingMode(len);
                    doChunked = false;
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("invalid Content-Length header value: " + v);
                }
            }
            conn.setRequestProperty(p, v);
        }
        if (doChunked) {
            conn.setChunkedStreamingMode(8192);
        }
        conn.setRequestProperty("User-Agent", this.userAgent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readResponse(InputStream istream) throws IOException, InterruptedException {
        log.debug((Object)"readResponse - START");
        if (this.responseStreamWrapper != null) {
            try {
                this.responseStreamWrapper.read(istream);
                return;
            }
            finally {
                this.responseStream = null;
            }
        } else if (this.responseDestination != null) {
            try {
                if (this.userNio) {
                    this.nioLoop(istream, this.responseDestination, 2 * this.bufferSize, 0L);
                    return;
                }
                String md5 = this.ioLoop(istream, this.responseDestination, 2 * this.bufferSize, 0L);
                if (this.getContentMD5() == null || md5 == null || md5.equals(this.getContentMD5())) return;
                StringBuilder sb = new StringBuilder();
                sb.append("MD5 mismatch: (header) ");
                sb.append(this.getContentMD5()).append(" != ").append(md5).append(" (bytes)");
                throw new IncorrectContentChecksumException(sb.toString());
            }
            finally {
                this.responseStream = null;
            }
        } else {
            log.debug((Object)"response capture not enabled");
        }
    }

    private String readErrorFromResponseBody(HttpURLConnection conn) throws IOException, InterruptedException {
        try {
            InputStream istream = conn.getErrorStream();
            if (istream == null) {
                istream = conn.getInputStream();
            }
            return this.readResponseBody(istream);
        }
        catch (IOException ignore) {
            log.debug((Object)"no response body");
            return "";
        }
    }

    protected String readResponseBody(InputStream istream) throws IOException, InterruptedException {
        ByteCountInputStream bcis = new ByteCountInputStream(istream, this.maxReadFully);
        try (ByteArrayOutputStream byteArrayOstream = new ByteArrayOutputStream();){
            try {
                this.ioLoop(bcis, byteArrayOstream, this.bufferSize, 0L);
            }
            catch (ByteLimitExceededException truncated) {
                log.debug((Object)"error response body truncated", (Throwable)truncated);
            }
            byteArrayOstream.flush();
            String string = new String(byteArrayOstream.toByteArray(), "UTF-8");
            return string;
        }
    }

    static {
        String jv = "Java " + System.getProperty("java.version") + ";" + System.getProperty("java.vendor");
        String os = System.getProperty("os.name") + " " + System.getProperty("os.version");
        DEFAULT_USER_AGENT = "OpenCADC/" + HttpTransfer.class.getPackage().getName() + "/" + jv + "/" + os;
    }

    public static enum RetryReason {
        NONE(0),
        SERVER(1),
        TRANSIENT(2),
        ALL(3);

        private int value;

        private RetryReason(int val) {
            this.value = val;
        }
    }
}

