/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.net;

import ca.nrc.cadc.auth.NotAuthenticatedException;
import ca.nrc.cadc.io.ByteLimitExceededException;
import ca.nrc.cadc.net.ExpectationFailedException;
import ca.nrc.cadc.net.FileContent;
import ca.nrc.cadc.net.HttpTransfer;
import ca.nrc.cadc.net.InputStreamWrapper;
import ca.nrc.cadc.net.OutputStreamWrapper;
import ca.nrc.cadc.net.PreconditionFailedException;
import ca.nrc.cadc.net.RangeNotSatisfiableException;
import ca.nrc.cadc.net.ResourceAlreadyExistsException;
import ca.nrc.cadc.net.ResourceNotFoundException;
import ca.nrc.cadc.net.TransientException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessControlException;
import javax.net.ssl.HttpsURLConnection;
import org.apache.log4j.Logger;

public class HttpUpload
extends HttpTransfer {
    private static Logger log = Logger.getLogger(HttpUpload.class);
    private InputStream istream;
    private OutputStreamWrapper wrapper;
    private FileContent fileContent;

    public HttpUpload(File src, URL dest) {
        super(dest, false);
        this.localFile = src;
        if (this.localFile == null) {
            throw new IllegalArgumentException("source File cannot be null");
        }
        this.setRequestProperty("Content-Length", Long.toString(this.localFile.length()));
    }

    public HttpUpload(FileContent src, URL dest) {
        super(dest, false);
        this.fileContent = src;
        if (this.fileContent == null) {
            throw new IllegalArgumentException("source FileContent cannot be null");
        }
        byte[] b = this.fileContent.getBytes();
        this.istream = new ByteArrayInputStream(b);
        this.setRequestProperty("Content-Length", Long.toString(b.length));
        if (src.getContentType() != null) {
            this.setRequestProperty("Content-Type", src.getContentType());
        }
    }

    public HttpUpload(InputStream src, URL dest) {
        super(dest, false);
        this.istream = src;
        if (this.istream == null) {
            throw new IllegalArgumentException("source InputStream cannot be null");
        }
    }

    public HttpUpload(OutputStreamWrapper src, URL dest) {
        super(dest, false);
        this.wrapper = src;
        if (this.wrapper == null) {
            throw new IllegalArgumentException("source OutputStreamWrapper cannot be null");
        }
    }

    @Deprecated
    public void setContentLength(long val) {
        this.setRequestProperty("Content-Length", Long.toString(val));
    }

    @Deprecated
    public void setContentMD5(String val) {
        this.setRequestProperty("Content-MD5", val);
    }

    @Deprecated
    public void setContentEncoding(String val) {
        this.setRequestProperty("Content-Encoding", val);
    }

    @Deprecated
    public void setContentType(String val) {
        this.setRequestProperty("Content-Type", val);
    }

    @Deprecated
    public String getResponseBody() throws IOException {
        try {
            if (this.responseStream != null) {
                return this.readResponseBody(this.responseStream);
            }
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("read interrupted", ex);
        }
        return null;
    }

    public void setResponseDestination(OutputStream responseDestination) {
        this.responseDestination = responseDestination;
        this.responseStreamWrapper = null;
    }

    public void setResponseStreamWrapper(InputStreamWrapper responseStreamWrapper) {
        this.responseStreamWrapper = responseStreamWrapper;
        this.responseDestination = null;
    }

    @Override
    public void setFollowRedirects(boolean followRedirects) {
        if (followRedirects) {
            throw new IllegalArgumentException("followRedirects=true not allowed for upload");
        }
    }

    public String toString() {
        return "HttpUpload[" + this.remoteURL + "," + this.localFile + "]";
    }

    @Override
    public void prepare() throws AccessControlException, NotAuthenticatedException, ByteLimitExceededException, ExpectationFailedException, IllegalArgumentException, PreconditionFailedException, ResourceAlreadyExistsException, ResourceNotFoundException, TransientException, IOException, InterruptedException, RangeNotSatisfiableException {
        boolean ok = false;
        try {
            this.doActionWithRetryLoop();
            ok = true;
        }
        finally {
            if (!ok) {
                this.fireEvent(7);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doAction() throws AccessControlException, NotAuthenticatedException, ByteLimitExceededException, ExpectationFailedException, IllegalArgumentException, PreconditionFailedException, ResourceAlreadyExistsException, ResourceNotFoundException, TransientException, IOException, InterruptedException {
        log.debug((Object)this.toString());
        if (!this.go) {
            return;
        }
        boolean throwTE = false;
        try {
            this.thread = Thread.currentThread();
            this.fireEvent(1);
            HttpURLConnection conn = (HttpURLConnection)this.remoteURL.openConnection();
            super.setRequestOptions(conn);
            conn.setRequestMethod("PUT");
            conn.setUseCaches(false);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            this.setRequestHeaders(conn);
            this.setRequestAuthHeaders(conn);
            if (conn instanceof HttpsURLConnection) {
                HttpsURLConnection sslConn = (HttpsURLConnection)conn;
                this.initHTTPS(sslConn);
            }
            this.doPut(conn);
            this.responseStream = conn.getInputStream();
            log.debug((Object)"completed");
            this.fireEvent(5);
        }
        finally {
            HttpUpload httpUpload = this;
            synchronized (httpUpload) {
                if (this.thread != null) {
                    if (Thread.interrupted()) {
                        this.go = false;
                    }
                    this.thread = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPut(HttpURLConnection conn) throws AccessControlException, NotAuthenticatedException, ByteLimitExceededException, ExpectationFailedException, IllegalArgumentException, PreconditionFailedException, ResourceAlreadyExistsException, ResourceNotFoundException, TransientException, IOException, InterruptedException, RangeNotSatisfiableException {
        OutputStream ostream = null;
        FileInputStream fin = null;
        InputStream in = null;
        try {
            ostream = conn.getOutputStream();
            this.fireEvent(2);
            if (this.localFile != null) {
                fin = new FileInputStream(this.localFile);
                in = fin;
            } else if (this.istream != null) {
                in = this.istream;
            }
            if (!(ostream instanceof BufferedOutputStream)) {
                log.debug((Object)"using BufferedOutputStream");
                ostream = new BufferedOutputStream(ostream, this.bufferSize);
            }
            if (in != null) {
                log.debug((Object)"using BufferedInputStream");
                in = new BufferedInputStream(in, this.bufferSize);
            }
            this.fireEvent(3);
            log.debug((Object)("before ioLoop: content-length = " + conn.getRequestProperty("Content-Length")));
            if (in != null) {
                this.ioLoop(in, ostream, 2 * this.bufferSize, 0L);
            } else {
                this.wrapper.write(ostream);
            }
            log.debug((Object)"OutputStream.flush");
            long writeStart = System.currentTimeMillis();
            ostream.flush();
            if (this.logIO) {
                long flushTime = System.currentTimeMillis() - writeStart;
                this.writeTime += flushTime;
                log.debug((Object)("Time (ms) to flush: " + flushTime));
            }
            log.debug((Object)"OutputStream.flush OK");
        }
        finally {
            if (this.istream != null) {
                log.debug((Object)"closing InputStream");
                try {
                    this.istream.close();
                }
                catch (IOException writeStart) {}
            }
            try {
                if (ostream != null) {
                    log.debug((Object)"OutputStream.close");
                    ostream.close();
                    log.debug((Object)"OutputStream.close OK");
                }
            }
            catch (IOException ignore) {
                log.debug((Object)"OutputStream.close FAIL", (Throwable)ignore);
            }
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (IOException iOException) {}
        }
        this.checkErrors(this.remoteURL, conn);
    }
}

