/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.net;

import ca.nrc.cadc.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class NetUtil {
    private static Logger log = Logger.getLogger(NetUtil.class);
    private static final int ERROR_BUFFER_SIZE = 512;
    private static final int MAX_ERROR_LENGTH = 16384;
    public static final String FORWARDED_FOR_CLIENT_IP_HEADER = "X-Forwarded-For";

    public static String getServerName(Class c) {
        String s;
        if (c != null && (s = System.getProperty(c.getName() + ".serverName")) != null) {
            return s;
        }
        if (c != null && (s = System.getProperty(c.getPackage().getName() + ".serverName")) != null) {
            return s;
        }
        s = System.getProperty(NetUtil.class.getPackage().getName() + ".serverName");
        if (s != null) {
            return s;
        }
        try {
            InetAddress inet = InetAddress.getLocalHost();
            return inet.getCanonicalHostName();
        }
        catch (UnknownHostException oops) {
            System.err.println("[" + NetUtil.class.getName() + "] network is poorly configured: " + oops);
            return "localhost";
        }
    }

    public static String encode(String s) {
        if (s == null) {
            return null;
        }
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding used", e);
        }
    }

    public static String decode(String s) {
        if (s == null) {
            return null;
        }
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported decoding used", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getErrorBody(HttpURLConnection conn) throws IOException {
        ByteArrayOutputStream out = null;
        InputStream in = null;
        try {
            int bytesRead;
            out = new ByteArrayOutputStream();
            in = conn.getErrorStream();
            if (in == null) {
                String string = "";
                return string;
            }
            byte[] buffer = new byte[512];
            while ((bytesRead = in.read(buffer)) > 0) {
                if (out.size() >= 16384) continue;
                out.write(buffer, 0, bytesRead);
            }
            String string = out.toString("UTF-8");
            return string;
        }
        catch (UnsupportedEncodingException e) {
            if (out.size() > 0) {
                String string = out.toString();
                return string;
            }
            String string = "";
            return string;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getErrorBody(HttpURLConnection conn, OutputStream dest) throws IOException {
        InputStream in = null;
        try {
            in = conn.getErrorStream();
            if (in != null) {
                int bytesRead;
                byte[] buffer = new byte[512];
                while ((bytesRead = in.read(buffer)) > 0) {
                    dest.write(buffer, 0, bytesRead);
                }
            }
        }
        finally {
            if (dest != null) {
                dest.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    public static String getDomainName(URL url) throws IOException {
        InetAddress address = InetAddress.getByName(url.getHost());
        String fqdn = address.getHostName();
        return NetUtil.getDomainName(fqdn);
    }

    public static String getDomainName(String serverName) throws IOException {
        String[] splitName = serverName.split("\\.");
        String domainName = splitName.length < 3 ? serverName : serverName.substring(serverName.indexOf(".") + 1);
        return domainName;
    }

    public static String getClientIP(HttpServletRequest request) {
        String forwardedFor = request.getHeader(FORWARDED_FOR_CLIENT_IP_HEADER);
        log.debug((Object)("X-Forwarded-For: " + forwardedFor));
        return StringUtil.hasText(forwardedFor) ? forwardedFor.split(",")[0].trim() : request.getRemoteAddr();
    }
}

