/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.profiler;

import org.apache.log4j.Logger;

public class Profiler {
    private static final Logger log = Logger.getLogger(Profiler.class);
    private long startTime;
    private long totalTime;
    protected String caller;

    public Profiler(Class caller) {
        this.caller = caller.getSimpleName();
        this.startTime = System.nanoTime();
        this.totalTime = 0L;
    }

    public void checkpoint(String op) {
        long now = System.nanoTime();
        long delta = (now - this.startTime) / 1000000L;
        if (log.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("{").append("\"caller\"");
            sb.append(":");
            sb.append("\"").append(this.caller).append("\"");
            sb.append(",").append("\"op\"");
            sb.append(":");
            sb.append("\"").append(op).append("\"");
            if (this.totalTime > 0L) {
                sb.append(",").append("\"delta\"");
                sb.append(":");
                sb.append(Long.toString(delta));
            }
            sb.append(",").append("\"time\"");
            sb.append(":");
            if (this.totalTime > 0L) {
                sb.append(Long.toString(this.totalTime));
            } else {
                sb.append(Long.toString(delta));
            }
            sb.append("}");
            log.info((Object)sb.toString());
        }
        this.totalTime += delta;
        this.startTime = now;
    }
}

