/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.thread;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import org.apache.log4j.Logger;

public class ThreadedRunnableExecutor {
    private static Logger log = Logger.getLogger(ThreadedRunnableExecutor.class);
    private final String poolBasename = ThreadedRunnableExecutor.class.getName();
    private final BlockingQueue<Runnable> taskQueue;
    private final ArrayList<WorkerThread> threads;

    public ThreadedRunnableExecutor(BlockingQueue<Runnable> blockingQueue, int nthreads) {
        if (nthreads <= 0) {
            throw new IllegalArgumentException("nthreads should > 1 (" + nthreads + ")");
        }
        this.taskQueue = blockingQueue;
        this.threads = new ArrayList(nthreads);
        log.info((Object)(this.poolBasename + " - starting up"));
        log.debug((Object)("initial thread count: " + this.threads.size() + " requested size: " + nthreads));
        while (this.threads.size() < nthreads) {
            int threadNum = this.threads.size() + 1;
            log.debug((Object)("adding worker thread " + threadNum));
            WorkerThread t = new WorkerThread();
            t.setDaemon(true);
            t.setName(this.poolBasename + "-" + threadNum);
            t.setPriority(1);
            this.threads.add(t);
            t.start();
        }
        log.debug((Object)("after pool startup - thread count: " + this.threads.size() + " requested size: " + nthreads));
        log.debug((Object)(this.poolBasename + " - ctor done"));
    }

    public void terminate() {
        log.debug((Object)(this.poolBasename + ".terminate() starting"));
        Iterator<WorkerThread> threadIter = this.threads.iterator();
        while (threadIter.hasNext()) {
            WorkerThread t = threadIter.next();
            log.debug((Object)(this.poolBasename + ".terminate() interrupting WorkerThread " + t.getName()));
            threadIter.remove();
            t.interrupt();
        }
        log.debug((Object)(this.poolBasename + ".terminate() DONE"));
    }

    public boolean getAllThreadsIdle() {
        boolean ret = true;
        for (WorkerThread t : this.threads) {
            ret = ret && t.idle();
        }
        return ret;
    }

    private class WorkerThread
    extends Thread {
        Runnable currentTask;

        WorkerThread() {
        }

        boolean idle() {
            return this.currentTask == null;
        }

        @Override
        public void run() {
            log.debug((Object)(ThreadedRunnableExecutor.this.poolBasename + " - START"));
            boolean cont = true;
            while (cont) {
                try {
                    log.debug((Object)"taking from taskQueue");
                    this.currentTask = null;
                    this.currentTask = (Runnable)ThreadedRunnableExecutor.this.taskQueue.take();
                    log.debug((Object)"running current task");
                    this.currentTask.run();
                    log.debug((Object)"finished running task");
                }
                catch (InterruptedException ex) {
                    log.debug((Object)("thread interrupted: " + ex));
                    return;
                }
                catch (Exception ignore) {
                    log.debug((Object)"poorly behaved task threw an exception.");
                }
                finally {
                    this.currentTask = null;
                }
            }
            log.debug((Object)(ThreadedRunnableExecutor.this.poolBasename + " - END"));
        }
    }
}

