/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class BucketSelector {
    private static final Logger log = Logger.getLogger(BucketSelector.class);
    public static final String BUCKET_CHARS = "0123456789abcdef";
    private static final int MAX_PREFIX_LENGTH = 1;
    private final String rangeMin;
    private final String rangeMax;
    private final TreeSet<String> bucketList = new TreeSet();

    public Iterator<String> getBucketIterator() {
        return this.bucketList.iterator();
    }

    public BucketSelector(String selector) {
        if (selector == null) {
            throw new IllegalArgumentException("BucketSelector: selector cannot be null");
        }
        String[] minMax = selector.split("-");
        if (minMax.length > 2) {
            throw new IllegalArgumentException("invalid prefix range: single value or range only: " + selector);
        }
        this.rangeMin = minMax[0].trim().toLowerCase();
        this.rangeMax = minMax.length == 1 ? this.rangeMin : minMax[1].trim().toLowerCase();
        if (1 > this.rangeMin.length() || this.rangeMin.length() > 1 || 1 > this.rangeMax.length() || this.rangeMax.length() > 1) {
            throw new IllegalArgumentException("invalid bucket prefix (" + this.rangeMin + " or " + this.rangeMax + "): max length is " + 1);
        }
        log.debug((Object)("acceptable length: " + this.rangeMin + " - " + this.rangeMax));
        int min = BUCKET_CHARS.indexOf(this.rangeMin);
        if (min == -1) {
            throw new IllegalArgumentException("invalid bucket prefix: " + this.rangeMin);
        }
        int max = BUCKET_CHARS.indexOf(this.rangeMax);
        if (max == -1) {
            throw new IllegalArgumentException("invalid bucket prefix: " + this.rangeMax);
        }
        if (max < min) {
            throw new IllegalArgumentException("invalid prefix range (min - max): " + this.rangeMin + " - " + this.rangeMax);
        }
        log.debug((Object)("range values as ints: " + min + ", " + max));
        for (int i = min; i <= max; ++i) {
            this.bucketList.add(Character.toString(BUCKET_CHARS.charAt(i)));
            log.debug((Object)("added " + BUCKET_CHARS.charAt(i)));
        }
    }

    public String getMinBucket() {
        return this.rangeMin;
    }

    public String getMinBucket(int padLength) {
        char[] ca = new char[padLength];
        Arrays.fill(ca, '0');
        int i = 0;
        for (char c : this.rangeMin.toCharArray()) {
            ca[i++] = c;
        }
        return String.copyValueOf(ca);
    }

    public String getMaxBucket() {
        return this.rangeMax;
    }

    public String getMaxBucket(int padLength) {
        char[] ca = new char[padLength];
        Arrays.fill(ca, 'f');
        int i = 0;
        for (char c : this.rangeMax.toCharArray()) {
            ca[i++] = c;
        }
        return String.copyValueOf(ca);
    }

    public String toString() {
        return "BucketSelector[" + this.rangeMin + "," + this.rangeMax + "]";
    }
}

