/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.util;

import java.text.NumberFormat;
import java.util.StringTokenizer;

public class CoordUtil {
    public static String DEGREE_SYMBOL = new Character('\u00b0').toString();
    private static String raSeparators = "'\"hmsHMS:";
    private static String decSeparators = "'\"dmsDMS:" + DEGREE_SYMBOL;
    private static NumberFormat raFormat = NumberFormat.getInstance();
    private static NumberFormat decFormat = NumberFormat.getInstance();

    public static String[] degreesToSexigessimal(double ra, double dec) {
        return new String[]{CoordUtil.degreesToRA(ra), CoordUtil.degreesToDEC(dec)};
    }

    public static String degreesToRA(double val) {
        while (val < 0.0) {
            val += 360.0;
        }
        while (val >= 360.0) {
            val -= 360.0;
        }
        int h = (int)(val / 15.0);
        int m = (int)((val -= (double)h * 15.0) * 4.0);
        val -= (double)m / 4.0;
        String d = Double.toString(val *= 240.0);
        String s = null;
        String hh = Integer.toString(h);
        String mm = Integer.toString(m);
        if (h < 10) {
            hh = "0" + h;
        }
        if (m < 10) {
            mm = "0" + m;
        }
        s = hh + ":" + mm + ":";
        return s + raFormat.format(val);
    }

    public static String degreesToDEC(double val) {
        if (val < -90.0 || val > 90.0) {
            throw new IllegalArgumentException("value " + val + " out of bounds: [-90.0, 90.0]");
        }
        String sign = "+";
        if (val < 0.0) {
            sign = "-";
            val *= -1.0;
        }
        int deg = (int)val;
        int m = (int)((val -= (double)deg) * 60.0);
        val -= (double)m / 60.0;
        String d = Double.toString(val *= 3600.0);
        String degs = Integer.toString(deg);
        if (deg < 10) {
            degs = "0" + degs;
        }
        String min = Integer.toString(m);
        if (m < 10) {
            min = "0" + m;
        }
        String s = sign + degs + ":" + min + ":";
        return s + decFormat.format(val);
    }

    public static double[] sexigessimalToDegrees(String ra, String dec) throws NumberFormatException {
        return new double[]{CoordUtil.raToDegrees(ra), CoordUtil.decToDegrees(dec)};
    }

    public static double raToDegrees(String ra) throws NumberFormatException {
        double ret;
        String str;
        StringTokenizer st = new StringTokenizer(ra, raSeparators, true);
        double h = Double.NaN;
        double m = 0.0;
        double s = 0.0;
        if (st.hasMoreTokens()) {
            h = Double.parseDouble(st.nextToken());
        }
        if (st.hasMoreTokens() && ((str = st.nextToken()).equals("h") || str.equals(":"))) {
            h *= 15.0;
        }
        if (st.hasMoreTokens()) {
            m = Double.parseDouble(st.nextToken());
        }
        if (st.hasMoreTokens()) {
            st.nextToken();
        }
        if (st.hasMoreTokens()) {
            s = Double.parseDouble(st.nextToken());
        }
        if (Double.isNaN(h)) {
            throw new IllegalArgumentException("empty string (RA)");
        }
        for (ret = h + m / 4.0 + s / 240.0; ret < 0.0; ret += 360.0) {
        }
        while (ret > 360.0) {
            ret -= 360.0;
        }
        return ret;
    }

    public static double raToRadians(String ra) throws NumberFormatException {
        return CoordUtil.raToDegrees(ra) * Math.PI / 180.0;
    }

    public static String radiansToRA(double raRadians) {
        return CoordUtil.degreesToRA(raRadians * 180.0 / Math.PI);
    }

    public static double decToDegrees(String dec) throws IllegalArgumentException, NumberFormatException {
        StringTokenizer st = new StringTokenizer(dec, decSeparators);
        double d = Double.NaN;
        double m = 0.0;
        double s = 0.0;
        if (st.hasMoreTokens()) {
            d = Double.parseDouble(st.nextToken());
        }
        if (st.hasMoreTokens()) {
            m = Double.parseDouble(st.nextToken());
        }
        if (st.hasMoreTokens()) {
            s = Double.parseDouble(st.nextToken());
        }
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("empty string (DEC)");
        }
        double ret = d + m / 60.0 + s / 3600.0;
        if (dec.startsWith("-")) {
            ret = d - m / 60.0 - s / 3600.0;
        }
        if (-90.0 <= ret && ret <= 90.0) {
            return ret;
        }
        throw new IllegalArgumentException("DEC must be in [-90,90]: " + ret);
    }

    public static double decToRadians(String dec) throws IllegalArgumentException, NumberFormatException {
        return CoordUtil.decToDegrees(dec) * Math.PI / 180.0;
    }

    public static String radiansToDec(double decRadians) {
        return CoordUtil.degreesToDEC(decRadians * 180.0 / Math.PI);
    }

    static {
        raFormat.setMaximumFractionDigits(1);
        raFormat.setMinimumFractionDigits(1);
        raFormat.setMaximumIntegerDigits(2);
        raFormat.setMinimumIntegerDigits(2);
        decFormat.setMaximumFractionDigits(1);
        decFormat.setMinimumFractionDigits(1);
        decFormat.setMaximumIntegerDigits(2);
        decFormat.setMinimumIntegerDigits(2);
    }
}

