/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.util;

import ca.nrc.cadc.net.NetUtil;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.apache.log4j.Logger;

public class FileUtil {
    private static final Logger log = Logger.getLogger(FileUtil.class);

    public static boolean delete(File f, boolean recursive) throws IOException {
        if (!f.exists()) {
            return false;
        }
        if (recursive && f.isDirectory()) {
            File[] children;
            for (File c : children = f.listFiles()) {
                if (FileUtil.delete(c, true)) continue;
                return false;
            }
        }
        return f.delete();
    }

    public static boolean compare(File file1, File file2) throws IOException {
        long cs2;
        long cs1 = FileUtil.checksum(file1);
        return cs1 == (cs2 = FileUtil.checksum(file2));
    }

    public static long checksum(File file) throws IOException {
        FileInputStream fileInStream = new FileInputStream(file);
        CheckedInputStream checkedInStream = new CheckedInputStream(fileInStream, new CRC32());
        BufferedInputStream bufferedInStream = new BufferedInputStream(checkedInStream);
        while (bufferedInStream.read() != -1) {
        }
        return checkedInStream.getChecksum().getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(File f) throws IOException {
        FilterInputStream dis = null;
        try {
            dis = new DataInputStream(new FileInputStream(f));
            byte[] ret = new byte[(int)f.length()];
            ((DataInputStream)dis).readFully(ret);
            dis.close();
            byte[] byArray = ret;
            return byArray;
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static URL getURLFromResource(String resourceName, Class runningClass) {
        URL url = runningClass.getClassLoader().getResource(resourceName);
        if (url == null) {
            url = runningClass.getClassLoader().getResource("/" + resourceName);
        }
        return url;
    }

    public static File getFileFromResource(String resourceFileName, Class runningClass) {
        URL url = FileUtil.getURLFromResource(resourceFileName, runningClass);
        if (url == null) {
            throw new MissingResourceException("Resource not found: " + resourceFileName, runningClass.getName(), resourceFileName);
        }
        return FileUtil.getFileFromURL(url);
    }

    public static File getFileFromURL(URL url) {
        log.debug((Object)("getFileFromURL: " + url));
        String path = url.getPath();
        File found = new File(URI.create(url.toExternalForm()));
        File f = found.exists() ? found : new File(NetUtil.decode(path));
        return f;
    }
}

