/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.util;

import java.lang.reflect.Array;

public class HashUtil {
    public static final int SEED = 23;
    private static final int fODD_PRIME_NUMBER = 37;

    public static int hash(int someSeed, boolean someBoolean) {
        return HashUtil.firstTerm(someSeed) + (someBoolean ? 1 : 0);
    }

    public static int hash(int someSeed, char someChar) {
        return HashUtil.firstTerm(someSeed) + someChar;
    }

    public static int hash(int someSeed, int someInt) {
        return HashUtil.firstTerm(someSeed) + someInt;
    }

    public static int hash(int someSeed, long someLong) {
        return HashUtil.firstTerm(someSeed) + (int)(someLong ^ someLong >>> 32);
    }

    public static int hash(int someSeed, float someFloat) {
        return HashUtil.hash(someSeed, Float.floatToIntBits(someFloat));
    }

    public static int hash(int someSeed, double someDouble) {
        return HashUtil.hash(someSeed, Double.doubleToLongBits(someDouble));
    }

    public static int hash(int seed, Object obj) {
        int result = seed;
        if (obj == null) {
            result = HashUtil.hash(result, 0);
        } else if (!HashUtil.isArray(obj)) {
            result = HashUtil.hash(result, obj.hashCode());
        } else {
            int length = Array.getLength(obj);
            for (int idx = 0; idx < length; ++idx) {
                Object item = Array.get(obj, idx);
                result = HashUtil.hash(result, item);
            }
        }
        return result;
    }

    private static int firstTerm(int someSeed) {
        return 37 * someSeed;
    }

    private static boolean isArray(Object anObject) {
        return anObject.getClass().isArray();
    }
}

