/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.util;

import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.WriterAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class Log4jInit {
    private static boolean consoleAppendersCreated = false;
    private static final String SHORT_FORMAT = "%-4r [%t] %-5p %c{1} - %m\n";
    private static final String LONG_FORMAT_A = "%d{yyyy-MM-dd HH:mm:ss.SSS}";
    private static final String LONG_FORMAT_B = "[%t] %-5p %c{1} - %m\n";
    private static final String MESSAGE_ONLY_FORMAT = "%m\n";
    private static List<Writer> logWriters = new ArrayList<Writer>();

    private static Level toV2(org.apache.log4j.Level level) {
        switch (level.toInt()) {
            case 40000: {
                return Level.ERROR;
            }
            case 30000: {
                return Level.WARN;
            }
            case 20000: {
                return Level.INFO;
            }
            case 10000: {
                return Level.DEBUG;
            }
            case 5000: {
                return Level.TRACE;
            }
        }
        throw new IllegalArgumentException("unexpected level: " + level);
    }

    public static synchronized void setLevel(String pkg, org.apache.log4j.Level level) {
        Log4jInit.setLevel(null, pkg, level);
    }

    public static synchronized void setLevel(String appName, String pkg, org.apache.log4j.Level level) {
        Log4jInit.createLog4jConsoleAppenders(appName);
        Configurator.setLevel((String)pkg, (Level)Log4jInit.toV2(level));
    }

    public static synchronized void setLevel(String pkg, org.apache.log4j.Level level, Writer dest) {
        Log4jInit.createLog4jWriterAppender(dest);
        Configurator.setLevel((String)pkg, (Level)Log4jInit.toV2(level));
    }

    private static synchronized void createLog4jConsoleAppenders(String appName) {
        if (!consoleAppendersCreated) {
            boolean messageOnly = "true".equals(System.getProperty(Log4jInit.class.getName() + ".messageOnly"));
            String pattern = "%d{yyyy-MM-dd HH:mm:ss.SSS}[%t] %-5p %c{1} - %m\n";
            if (messageOnly) {
                pattern = MESSAGE_ONLY_FORMAT;
            } else if (appName != null) {
                pattern = "%d{yyyy-MM-dd HH:mm:ss.SSS} " + appName + " " + LONG_FORMAT_B;
            }
            ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
            AppenderComponentBuilder appenderBuilder = builder.newAppender("out", "Console");
            appenderBuilder.add((LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", pattern));
            appenderBuilder.addAttribute("target", (Enum)ConsoleAppender.Target.SYSTEM_OUT);
            builder.add(appenderBuilder);
            builder.add((RootLoggerComponentBuilder)builder.newRootLogger(Level.ERROR).add(builder.newAppenderRef("out")));
            Configuration conf = (Configuration)builder.build();
            Configurator.reconfigure((Configuration)conf);
            consoleAppendersCreated = true;
        }
    }

    private static synchronized void createLog4jWriterAppender(Writer writer) {
        if (writer != null && !logWriters.contains(writer)) {
            String pattern = "%d{yyyy-MM-dd HH:mm:ss.SSS}[%t] %-5p %c{1} - %m\n";
            ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
            Configuration config = (Configuration)builder.build();
            Configurator.reconfigure((Configuration)config);
            for (String aname : config.getRootLogger().getAppenders().keySet()) {
                config.getRootLogger().removeAppender(aname);
            }
            PatternLayout layout = PatternLayout.newBuilder().withPattern(pattern).build();
            WriterAppender appender = ((WriterAppender.Builder)((WriterAppender.Builder)WriterAppender.newBuilder().setName("writeLogger")).setTarget(writer).setLayout((Layout)layout)).build();
            appender.start();
            config.addAppender((Appender)appender);
            Level level = null;
            Filter filter = null;
            for (LoggerConfig loggerConfig : config.getLoggers().values()) {
                loggerConfig.addAppender((Appender)appender, level, filter);
            }
            config.getRootLogger().addAppender((Appender)appender, level, filter);
            logWriters.add(writer);
        }
    }
}

