/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultiValuedProperties {
    private final Map<String, List<String>> props = new HashMap<String, List<String>>();

    public boolean isEmpty() {
        return this.props.isEmpty();
    }

    public List<String> getProperty(String name) {
        if (this.props == null) {
            throw new IllegalStateException("no properties loaded");
        }
        List<String> ret = this.props.get(name);
        if (ret == null) {
            ret = Collections.emptyList();
        }
        return ret;
    }

    public String getFirstPropertyValue(String key) {
        List<String> values = this.getProperty(key);
        if (!values.isEmpty()) {
            return values.get(0);
        }
        return null;
    }

    public Set<String> keySet() {
        if (this.props == null) {
            return null;
        }
        return this.props.keySet();
    }

    public void load(InputStream istream) throws IOException {
        String strLine;
        BufferedReader br = new BufferedReader(new InputStreamReader(istream));
        while ((strLine = br.readLine()) != null) {
            int idxColon;
            char firstChar;
            int lineLength = (strLine = strLine.trim()).length();
            if (lineLength == 0 || (firstChar = strLine.charAt(0)) == '#' || firstChar == '!' || (idxColon = strLine.indexOf(61)) == 0) continue;
            String key = strLine.substring(0, idxColon).trim();
            String value = strLine.substring(idxColon + 1).trim();
            List<String> valueList = this.props.get(key);
            if (valueList == null) {
                valueList = new ArrayList<String>();
                this.props.put(key, valueList);
            }
            valueList.add(value);
        }
        br.close();
    }
}

