/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.util;

import ca.nrc.cadc.util.InvalidConfigException;
import ca.nrc.cadc.util.MultiValuedProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class PropertiesReader {
    private static final Logger log = Logger.getLogger(PropertiesReader.class);
    private static final String DEFAULT_CONFIG_DIR = System.getProperty("user.home") + "/config";
    public static final String CONFIG_DIR_SYSTEM_PROPERTY = PropertiesReader.class.getName() + ".dir";
    private final File propertiesFile;
    private String cachedPropsKey;
    private static Map<String, MultiValuedProperties> cachedProperties = new ConcurrentHashMap<String, MultiValuedProperties>();

    public PropertiesReader(String filename) throws InvalidConfigException {
        if (filename == null) {
            throw new IllegalArgumentException("fileName cannot be null.");
        }
        String configDir = DEFAULT_CONFIG_DIR;
        if (System.getProperty(CONFIG_DIR_SYSTEM_PROPERTY) != null) {
            configDir = System.getProperty(CONFIG_DIR_SYSTEM_PROPERTY);
        }
        this.propertiesFile = new File(new File(configDir), filename);
        this.cachedPropsKey = this.propertiesFile.getAbsolutePath();
        log.debug((Object)("properties file: " + this.propertiesFile));
    }

    public PropertiesReader(File src) {
        if (src == null) {
            throw new IllegalArgumentException("src cannot be null.");
        }
        this.propertiesFile = src;
        this.cachedPropsKey = this.propertiesFile.getAbsolutePath();
        log.debug((Object)("properties file: " + this.propertiesFile));
    }

    public boolean canRead() {
        return Files.isReadable(this.propertiesFile.toPath());
    }

    public MultiValuedProperties getAllProperties() {
        MultiValuedProperties cached;
        MultiValuedProperties properties = new MultiValuedProperties();
        boolean tryCache = false;
        try {
            if (this.canRead()) {
                FileInputStream in = new FileInputStream(this.propertiesFile);
                properties.load(in);
                cachedProperties.put(this.cachedPropsKey, properties);
            } else {
                tryCache = true;
            }
        }
        catch (IOException ex) {
            log.warn((Object)("failed to read " + this.cachedPropsKey + ": " + ex));
            tryCache = true;
        }
        if (tryCache && (cached = cachedProperties.get(this.cachedPropsKey)) != null) {
            properties = cached;
        }
        return properties;
    }

    @Deprecated
    public List<String> getPropertyValues(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Provided key is null.");
        }
        List<String> ret = null;
        MultiValuedProperties properties = this.getAllProperties();
        if (properties != null) {
            ret = properties.getProperty(key);
        }
        return ret;
    }

    @Deprecated
    public String getFirstPropertyValue(String key) {
        List<String> values = this.getPropertyValues(key);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }
}

