/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.util;

import ca.nrc.cadc.util.Base64;
import ca.nrc.cadc.util.RsaSignatureVerifier;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import org.apache.log4j.Logger;

public class RsaSignatureGenerator
extends RsaSignatureVerifier {
    private static Logger log = Logger.getLogger(RsaSignatureGenerator.class);
    protected static RsaSignatureGenerator inst;
    protected PrivateKey privKey;
    public static final String PRIV_KEY_FILE_NAME = "RsaSignaturePriv.key";
    public static final String PRIV_KEY_START = "-----BEGIN PRIVATE KEY-----";
    public static final String PRIV_KEY_END = "-----END PRIVATE KEY-----";

    @Deprecated
    public RsaSignatureGenerator() {
        this(PRIV_KEY_FILE_NAME);
    }

    @Deprecated
    public RsaSignatureGenerator(String keyFilename) {
        super(keyFilename, true);
        File keyFile = this.findFile(keyFilename);
        this.initPrivateKey(keyFile);
    }

    public RsaSignatureGenerator(File keyFile) {
        super(keyFile, true);
        this.initPrivateKey(keyFile);
    }

    public RsaSignatureGenerator(byte[] keyContent) {
        super(keyContent, true);
        this.initPrivateKey(keyContent);
    }

    private void initPrivateKey(File keysFile) {
        try (BufferedReader br = new BufferedReader(new FileReader(keysFile));){
            StringBuilder sb = null;
            boolean read = false;
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.equalsIgnoreCase(PRIV_KEY_START)) {
                    if (read) {
                        throw new IllegalArgumentException("Corrupted keys file");
                    }
                    if (this.privKey != null) {
                        throw new IllegalStateException("Found two private keys");
                    }
                    read = true;
                    sb = new StringBuilder();
                    continue;
                }
                if (line.equalsIgnoreCase(PRIV_KEY_END)) {
                    if (!read) {
                        throw new IllegalArgumentException("Corrupted keys file");
                    }
                    read = false;
                    String payload = sb.toString();
                    byte[] bytes = Base64.decode(payload);
                    this.initPrivateKey(bytes);
                }
                if (!read) continue;
                sb.append(line);
            }
        }
        catch (IOException e) {
            String msg = "Could not read keys";
            throw new RuntimeException(msg, e);
        }
        if (this.privKey == null) {
            String msg = "No valid private key found";
            throw new IllegalStateException(msg);
        }
    }

    private void initPrivateKey(byte[] keysContent) {
        KeyFactory keyFactory = null;
        try {
            keyFactory = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e1) {
            throw new RuntimeException("BUG: Wrong algorithm RSA", e1);
        }
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(keysContent);
        try {
            this.privKey = keyFactory.generatePrivate(privateKeySpec);
            RSAPrivateCrtKey privk = (RSAPrivateCrtKey)this.privKey;
            RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(privk.getModulus(), privk.getPublicExponent());
            PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
            this.pubKeys.add(publicKey);
        }
        catch (InvalidKeySpecException e) {
            log.warn((Object)"Could not parse private key", (Throwable)e);
        }
    }

    public byte[] sign(InputStream is) throws IOException, InvalidKeyException {
        if (this.privKey == null) {
            throw new IllegalStateException("No private key available for signing");
        }
        try {
            Signature sig = this.getSignature();
            sig.initSign(this.privKey);
            byte[] data = new byte[1024];
            int ndRead = is.read(data);
            while (ndRead > 0) {
                sig.update(data, 0, ndRead);
                ndRead = is.read(data);
            }
            return sig.sign();
        }
        catch (SignatureException e) {
            throw new RuntimeException("Signature problem", e);
        }
    }

    public PrivateKey getPrivateKey() {
        return this.privKey;
    }

    private Signature getSignature() {
        try {
            return Signature.getInstance("SHA1withRSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("BUG: Wrong signature algorithm SHA1withRSA", e);
        }
    }

    @Deprecated
    public static void genKeyPair(String directory) throws FileNotFoundException {
        RsaSignatureGenerator.genKeyPair(new File(directory));
    }

    public static void genKeyPair(File directory) throws FileNotFoundException {
        RsaSignatureGenerator.genKeyPair(new File(directory, "RsaSignaturePub.key"), new File(directory, PRIV_KEY_FILE_NAME), 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void genKeyPair(File pubKey, File privKey, int keyLength) throws FileNotFoundException {
        KeyPair keyPair = RsaSignatureGenerator.getKeyPair(keyLength);
        String base64PrivKey = Base64.encodeLines(keyPair.getPrivate().getEncoded());
        String base64PubKey = Base64.encodeLines(keyPair.getPublic().getEncoded());
        try (PrintWriter outPub = new PrintWriter(pubKey);){
            outPub.println("-----BEGIN PUBLIC KEY-----");
            outPub.print(base64PubKey);
            outPub.println("-----END PUBLIC KEY-----");
        }
        try (PrintWriter outPriv = new PrintWriter(privKey);){
            outPriv.println(PRIV_KEY_START);
            outPriv.print(base64PrivKey);
            outPriv.println(PRIV_KEY_END);
        }
    }

    public static KeyPair getKeyPair(int keyLength) {
        KeyPairGenerator kpg;
        try {
            kpg = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("BUG: illegal key algorithm - RSA", e);
        }
        kpg.initialize(keyLength);
        KeyPair keyPair = kpg.genKeyPair();
        return keyPair;
    }
}

