/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.util;

import ca.nrc.cadc.util.Base64;
import ca.nrc.cadc.util.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.Set;
import org.apache.log4j.Logger;

public class RsaSignatureVerifier {
    private static Logger log = Logger.getLogger(RsaSignatureVerifier.class);
    private static final String DEFAULT_CONFIG_DIR = System.getProperty("user.home") + "/config/";
    protected static RsaSignatureVerifier inst;
    protected Set<PublicKey> pubKeys = new HashSet<PublicKey>();
    protected static final String KEY_ALGORITHM = "RSA";
    protected static final String SIG_ALGORITHM = "SHA1withRSA";
    public static final String PUB_KEY_FILE_NAME = "RsaSignaturePub.key";
    public static final String PUB_KEY_START = "-----BEGIN PUBLIC KEY-----";
    public static final String PUB_KEY_END = "-----END PUBLIC KEY-----";

    @Deprecated
    public RsaSignatureVerifier() {
        this(PUB_KEY_FILE_NAME);
    }

    @Deprecated
    public RsaSignatureVerifier(String keyFilename) {
        File keyFile = this.findFile(keyFilename);
        this.init(keyFile);
    }

    public RsaSignatureVerifier(File keyFile) {
        if (!keyFile.exists()) {
            throw new MissingResourceException(keyFile.getAbsolutePath(), null, null);
        }
        this.init(keyFile);
    }

    public RsaSignatureVerifier(byte[] keyContent) {
        this.init(keyContent);
    }

    public RsaSignatureVerifier(byte[] keyContent, boolean isPrivateKey) {
        if (!isPrivateKey) {
            this.init(keyContent);
        }
    }

    @Deprecated
    protected RsaSignatureVerifier(String keyFilename, boolean isPrivateKeyFile) {
        File keyFile = this.findFile(keyFilename);
        if (!isPrivateKeyFile) {
            this.init(keyFile);
        }
    }

    protected RsaSignatureVerifier(File keyFile, boolean isPrivateKeyFile) {
        if (!keyFile.exists()) {
            throw new MissingResourceException(keyFile.getAbsolutePath(), null, null);
        }
        if (!isPrivateKeyFile) {
            this.init(keyFile);
        }
    }

    protected final File findFile(String fname) throws MissingResourceException {
        File ret = new File(DEFAULT_CONFIG_DIR, fname);
        if (!ret.exists()) {
            ret = FileUtil.getFileFromResource(fname, this.getClass());
        }
        return ret;
    }

    protected void init(File keysFile) {
        try {
            log.debug((Object)("read pub keys: " + keysFile));
            try (BufferedReader br = new BufferedReader(new FileReader(keysFile));){
                String line;
                StringBuilder sb = null;
                boolean readPub = false;
                while ((line = br.readLine()) != null) {
                    if (line.equalsIgnoreCase(PUB_KEY_START)) {
                        if (readPub) {
                            throw new IllegalArgumentException("Corrupted keys file");
                        }
                        readPub = true;
                        sb = new StringBuilder();
                        continue;
                    }
                    if (line.equalsIgnoreCase(PUB_KEY_END)) {
                        if (!readPub) {
                            throw new IllegalArgumentException("Corrupted keys file");
                        }
                        readPub = false;
                        String payload = sb.toString();
                        byte[] bytes = Base64.decode(payload);
                        this.init(bytes);
                    }
                    if (!readPub) continue;
                    sb.append(line);
                }
            }
        }
        catch (IOException e) {
            String msg = "Could not read keys";
            throw new RuntimeException(msg, e);
        }
        if (this.pubKeys.isEmpty()) {
            String msg = "No valid public keys found";
            throw new IllegalStateException(msg);
        }
    }

    protected void init(byte[] keysContent) {
        KeyFactory keyFactory = null;
        try {
            keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e1) {
            throw new RuntimeException("BUG: Wrong algorithm RSA", e1);
        }
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(keysContent);
        try {
            this.pubKeys.add(keyFactory.generatePublic(publicKeySpec));
        }
        catch (InvalidKeySpecException e) {
            log.warn((Object)"Could not parse public key", (Throwable)e);
        }
    }

    public boolean verify(InputStream is, byte[] sigBytes) throws IOException, InvalidKeyException {
        if (this.pubKeys.size() == 0) {
            throw new IllegalStateException("No public keys available for verifying");
        }
        try {
            HashSet<Signature> sigs = new HashSet<Signature>(this.pubKeys.size());
            for (PublicKey pubKey : this.pubKeys) {
                Signature sig = this.getSignature();
                sig.initVerify(pubKey);
                sigs.add(sig);
            }
            byte[] data = new byte[1024];
            int ndRead = is.read(data);
            while (ndRead > 0) {
                for (Signature sig : sigs) {
                    sig.update(data, 0, ndRead);
                }
                ndRead = is.read(data);
            }
            for (Signature sig : sigs) {
                if (!sig.verify(sigBytes)) continue;
                return true;
            }
            return false;
        }
        catch (SignatureException e) {
            throw new RuntimeException("Signature problem", e);
        }
    }

    public Set<PublicKey> getPublicKeys() {
        return this.pubKeys;
    }

    private Signature getSignature() {
        try {
            return Signature.getInstance(SIG_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("BUG: Wrong signature algorithm SHA1withRSA", e);
        }
    }
}

