/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    public static boolean hasLength(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean hasText(String str) {
        if (!StringUtil.hasLength(str)) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String trimLeadingWhitespace(String str) {
        if (str.length() == 0) {
            return str;
        }
        StringBuilder buf = new StringBuilder(str);
        while (buf.length() > 0 && Character.isWhitespace(buf.charAt(0))) {
            buf.deleteCharAt(0);
        }
        return buf.toString();
    }

    public static String trimTrailingWhitespace(String str) {
        if (str.length() == 0) {
            return str;
        }
        StringBuilder buf = new StringBuilder(str);
        while (buf.length() > 0 && Character.isWhitespace(buf.charAt(buf.length() - 1))) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    public static boolean contains(String searchString, String crit) {
        if (StringUtil.hasLength(searchString) && StringUtil.hasLength(crit)) {
            return searchString.indexOf(crit) >= 0;
        }
        return false;
    }

    public static boolean startsWith(String searchString, String crit) {
        if (StringUtil.hasLength(searchString) && StringUtil.hasLength(crit)) {
            return searchString.startsWith(crit);
        }
        return false;
    }

    public static boolean startsWithCaseInsensitive(String src, String what) {
        return src.regionMatches(true, 0, what, 0, what.length());
    }

    public static boolean containedIn(String searchString, String[] crit) {
        if (StringUtil.hasLength(searchString)) {
            for (int i = 0; i < crit.length; ++i) {
                if (!crit[i].equals(searchString)) continue;
                return true;
            }
        }
        return false;
    }

    public static String[] parseCmdLineStr(String toParse) {
        ArrayList<String> tokens = new ArrayList<String>();
        int currentCharIndex = 0;
        StringBuffer buffer = new StringBuffer();
        char current = ' ';
        String thisToParse = toParse.trim();
        boolean insideQuotes = false;
        while (currentCharIndex < thisToParse.length()) {
            char previous = current;
            current = thisToParse.charAt(currentCharIndex++);
            if (insideQuotes) {
                if (current == '\'') {
                    insideQuotes = false;
                    continue;
                }
                buffer.append(current);
                continue;
            }
            if (current == ' ' || current == '\t') {
                if (previous != '\\') {
                    tokens.add(buffer.toString());
                    buffer = new StringBuffer();
                    continue;
                }
                buffer.setCharAt(buffer.length() - 1, current);
                continue;
            }
            if (current == '\'') {
                if (previous != '\\') {
                    insideQuotes = true;
                    continue;
                }
                buffer.setCharAt(buffer.length() - 1, current);
                continue;
            }
            buffer.append(current);
        }
        if (buffer.length() > 0) {
            tokens.add(buffer.toString());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static String toString(String[] strArr) {
        if (strArr == null) {
            return "";
        }
        String deli = "";
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (String str : strArr) {
            sb.append(deli).append("\"").append(str).append("\"");
            if (!"".equals(deli)) continue;
            deli = ", ";
        }
        sb.append("]");
        return sb.toString();
    }

    public static String repeat(String str, int num) {
        if (num <= 0 || str == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = num;
        while (i-- > 0) {
            sb.append(str);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFromInputStream(InputStream inputStream, String charsetName) throws IOException {
        StringBuffer sb = new StringBuffer();
        BufferedReader buf = null;
        try {
            buf = new BufferedReader(new InputStreamReader(inputStream, charsetName));
            String line = buf.readLine();
            while (line != null) {
                sb.append(line);
                sb.append("\n");
                line = buf.readLine();
            }
        }
        finally {
            try {
                buf.close();
            }
            catch (IOException iOException) {}
        }
        return sb.toString();
    }

    public static boolean matches(String input, String regexp, boolean caseInsensitive) {
        Pattern p = caseInsensitive ? Pattern.compile(".*" + regexp + ".*", 2) : Pattern.compile(".*" + regexp + ".*");
        Matcher m = p.matcher(input);
        return m.matches();
    }
}

