/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.util;

import java.util.Comparator;
import java.util.UUID;

public class UUIDComparator
implements Comparator<UUID> {
    @Override
    public int compare(UUID u1, UUID u2) {
        return UUIDComparator.staticCompare(u1, u2);
    }

    private static int staticCompare(UUID u1, UUID u2) {
        int type = u1.version();
        int diff = type - u2.version();
        if (diff != 0) {
            return diff;
        }
        if (type == UUIDType.TIME_BASED.raw()) {
            diff = UUIDComparator.compareULongs(u1.timestamp(), u2.timestamp());
            if (diff == 0) {
                diff = UUIDComparator.compareULongs(u1.getLeastSignificantBits(), u2.getLeastSignificantBits());
            }
        } else {
            diff = UUIDComparator.compareULongs(u1.getMostSignificantBits(), u2.getMostSignificantBits());
            if (diff == 0) {
                diff = UUIDComparator.compareULongs(u1.getLeastSignificantBits(), u2.getLeastSignificantBits());
            }
        }
        return diff;
    }

    protected static final int compareULongs(long l1, long l2) {
        int diff = UUIDComparator.compareUInts((int)(l1 >> 32), (int)(l2 >> 32));
        if (diff == 0) {
            diff = UUIDComparator.compareUInts((int)l1, (int)l2);
        }
        return diff;
    }

    protected static final int compareUInts(int i1, int i2) {
        if (i1 < 0) {
            return i2 < 0 ? i1 - i2 : 1;
        }
        return i2 < 0 ? -1 : i1 - i2;
    }

    private static enum UUIDType {
        TIME_BASED(1),
        DCE(2),
        NAME_BASED_MD5(3),
        RANDOM_BASED(4),
        NAME_BASED_SHA1(5),
        UNKNOWN(0);

        private final int raw;

        private UUIDType(int rawi) {
            this.raw = rawi;
        }

        public int raw() {
            return this.raw;
        }
    }
}

