/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonInputter {
    public Document input(String json) throws JSONException {
        JSONObject rootJson = new JSONObject(json);
        List<String> keys = Arrays.asList(JSONObject.getNames((JSONObject)rootJson));
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        namespaces.add(Namespace.XML_NAMESPACE);
        Namespace namespace = this.getNamespace(namespaces, rootJson, keys);
        String rootKey = null;
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (String key : keys) {
            if (key.startsWith("@xmlns")) continue;
            if (key.startsWith("@")) {
                String value = rootJson.isNull(key) ? "" : this.getStringValue(rootJson.get(key));
                attributes.add(new Attribute(key.substring(1), value));
                continue;
            }
            if (rootKey != null) {
                throw new IllegalStateException("Found multiple root entries");
            }
            rootKey = key;
        }
        Object value = rootJson.get(rootKey);
        if (namespace == null) {
            JSONObject rootChild = (JSONObject)value;
            List<String> rootChildKeys = Arrays.asList(JSONObject.getNames((JSONObject)rootChild));
            namespace = this.getNamespace(namespaces, rootChild, rootChildKeys);
        }
        Element rootElement = new Element(rootKey, namespace);
        for (Attribute attribute : attributes) {
            rootElement.setAttribute(attribute);
        }
        this.processObject(rootKey, value, rootElement, namespace, namespaces);
        Document document = new Document();
        document.setRootElement(rootElement);
        return document;
    }

    private void processObject(String key, Object value, Element element, Namespace namespace, List<Namespace> namespaces) throws JSONException {
        if (value == null) {
            return;
        }
        if (value instanceof JSONObject) {
            this.processJSONObject((JSONObject)value, element, namespaces);
        } else {
            element.setText(this.getStringValue(value));
        }
    }

    private void processJSONObject(JSONObject jsonObject, Element element, List<Namespace> namespaces) throws JSONException {
        List<String> keys = Arrays.asList(JSONObject.getNames((JSONObject)jsonObject));
        Namespace namespace = this.getNamespace(namespaces, jsonObject, keys);
        if (namespace == null) {
            namespace = element.getNamespace();
        }
        for (String key : keys) {
            Object value;
            if (jsonObject.isNull(key)) continue;
            if (key.startsWith("@")) {
                value = jsonObject.get(key);
                if (key.contains(":")) {
                    boolean found = false;
                    String prefix = key.substring(1, key.indexOf(":"));
                    String newKey = "@" + key.substring(key.indexOf(":") + 1);
                    for (Namespace ns : namespaces) {
                        if (!ns.getPrefix().equals(prefix)) continue;
                        element.setAttribute(new Attribute(newKey.substring(1), this.getStringValue(value), ns));
                        found = true;
                        break;
                    }
                    if (found) continue;
                    String msg = "Missing namespace for prefix " + prefix;
                    throw new UnsupportedOperationException(msg);
                }
                if (key.equals("@xmlns")) continue;
                element.setAttribute(new Attribute(key.substring(1), this.getStringValue(value)));
                continue;
            }
            value = jsonObject.get(key);
            if (key.equals("$")) {
                if (value instanceof JSONArray) {
                    JSONArray jsonArray = (JSONArray)value;
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        JSONObject elementValue = (JSONObject)jsonArray.get(i);
                        List<String> elementKeys = Arrays.asList(JSONObject.getNames((JSONObject)elementValue));
                        String elementKey = elementKeys.get(0);
                        JSONObject elementObject = (JSONObject)elementValue.get(elementKey);
                        Element arrayElement = new Element(elementKey, namespace);
                        this.processJSONObject(elementObject, arrayElement, namespaces);
                        element.addContent((Content)arrayElement);
                    }
                    continue;
                }
                element.setText(this.getStringValue(value));
                continue;
            }
            Element child = new Element(key, namespace);
            if (value instanceof JSONObject) {
                this.processJSONObject((JSONObject)value, child, namespaces);
            }
            element.addContent((Content)child);
        }
    }

    private Namespace getNamespace(List<Namespace> namespaces, JSONObject jsonObject, List<String> keys) throws JSONException {
        for (String key : keys) {
            if (!key.equals("@xmlns")) continue;
            if (jsonObject.isNull(key)) break;
            String uri = jsonObject.getString(key);
            Namespace namespace = Namespace.getNamespace((String)uri);
            if (!namespaces.contains(namespace)) {
                namespaces.add(namespace);
            }
            return namespace;
        }
        return null;
    }

    private String getStringValue(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Integer || value instanceof Double || value instanceof Long) {
            return ((Number)value).toString();
        }
        if (value instanceof Boolean) {
            return ((Boolean)value).toString();
        }
        String error = "Unknown value " + value.getClass().getSimpleName() + " " + value.toString();
        throw new IllegalArgumentException(error);
    }
}

