/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.xml;

import ca.nrc.cadc.util.StringUtil;
import ca.nrc.cadc.xml.IterableContent;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;

public class JsonOutputter
implements Serializable {
    private static final long serialVersionUID = 20150205121500L;
    private static final Logger log = Logger.getLogger(JsonOutputter.class);
    private static final String QUOTE = "\"";
    private Format fmt = Format.getPrettyFormat();
    private final List<String> listElementNames = new ArrayList<String>();
    private final List<String> stringElementNames = new ArrayList<String>();

    public List<String> getListElementNames() {
        return this.listElementNames;
    }

    public List<String> getStringElementNames() {
        return this.stringElementNames;
    }

    public void setFormat(Format fmt) {
        this.fmt = fmt;
    }

    public void output(Document doc, Writer writer) throws IOException {
        PrintWriter pw = new PrintWriter(writer);
        pw.print("{ ");
        this.writeElement(doc.getRootElement(), pw, 1, false);
        this.indent(pw, 0);
        pw.print("}");
        pw.flush();
    }

    private void writeSchema(String uri, String pre, PrintWriter w) {
        w.print(QUOTE);
        w.print("@");
        w.print("xmlns");
        if (StringUtil.hasText(pre)) {
            w.print(":");
            w.print(pre);
        }
        w.print(QUOTE);
        w.print(" : ");
        w.print(QUOTE);
        w.print(uri);
        w.print(QUOTE);
    }

    private boolean writeSchemaAttributes(Element e, PrintWriter w, int i) throws IOException {
        boolean ret = false;
        for (Namespace ans : e.getNamespacesIntroduced()) {
            if (ret) {
                w.print(",");
            }
            ret = true;
            this.indent(w, i);
            String uri = ans.getURI();
            String pre = ans.getPrefix();
            this.writeSchema(uri, pre, w);
        }
        return ret;
    }

    private boolean writeAttributes(Element e, PrintWriter w, int i) throws IOException {
        boolean ret = this.writeSchemaAttributes(e, w, i);
        Iterator iter = e.getAttributes().iterator();
        if (ret && iter.hasNext()) {
            w.print(",");
        }
        while (iter.hasNext()) {
            ret = true;
            Attribute a = (Attribute)iter.next();
            this.indent(w, i);
            w.print(QUOTE);
            w.print("@");
            if (StringUtil.hasText(a.getNamespacePrefix())) {
                w.print(a.getNamespacePrefix());
                w.print(":");
            }
            w.print(a.getName());
            w.print(QUOTE);
            w.print(" : ");
            if (this.isBoolean(e.getName(), a.getValue()) || this.isNumeric(e.getName(), a.getValue())) {
                w.print(a.getValue());
            } else {
                w.print(QUOTE);
                w.print(a.getValue());
                w.print(QUOTE);
            }
            if (!iter.hasNext()) continue;
            w.print(",");
        }
        return ret;
    }

    private void writeElement(Element e, PrintWriter w, int i, boolean listItem) throws IOException {
        this.indent(w, i);
        if (listItem) {
            w.print(QUOTE);
            w.print(e.getName());
            w.print(QUOTE);
            w.print(" : ");
        } else {
            w.print(QUOTE);
            if (StringUtil.hasText(e.getNamespacePrefix())) {
                w.print(e.getNamespacePrefix());
                w.print(":");
            }
            w.print(e.getName());
            w.print(QUOTE);
            w.print(" : ");
        }
        w.print("{");
        boolean multiLine = true;
        boolean children = false;
        boolean attrs = this.writeAttributes(e, w, i + 1);
        boolean childListItem = this.listElementNames.contains(e.getName());
        if (childListItem) {
            if (attrs) {
                w.print(",");
            }
            this.indent(w, i + 1);
            w.print(QUOTE);
            w.print("$");
            w.print(QUOTE);
            w.print(" : ");
            w.print("[");
            children = this.writeChildElements(e, w, i + 2, childListItem, attrs);
            this.indent(w, i + 1);
            w.print("]");
        } else {
            children = this.writeChildElements(e, w, i + 1, childListItem, attrs);
        }
        if (!children && !childListItem) {
            if (attrs) {
                w.print(",");
                this.indent(w, i + 1);
            } else {
                multiLine = false;
            }
            w.print(QUOTE);
            w.print("$");
            w.print(QUOTE);
            w.print(" : ");
            String sval = e.getTextNormalize();
            if (this.isBoolean(e.getName(), sval) || this.isNumeric(e.getName(), sval)) {
                w.print(sval);
            } else {
                w.print(QUOTE);
                w.print(sval);
                w.print(QUOTE);
            }
        }
        if (multiLine) {
            this.indent(w, i);
        }
        w.print("}");
    }

    private boolean writeChildElements(Element e, PrintWriter w, int i, boolean listItem, boolean parentAttrs) throws IOException {
        boolean ret = false;
        Iterator<Object> iter = e.getChildren().iterator();
        if (e instanceof IterableContent) {
            iter = ((IterableContent)e).getContent().iterator();
        }
        if (iter.hasNext() && parentAttrs && !listItem) {
            w.print(",");
        }
        while (iter.hasNext()) {
            Element c = (Element)iter.next();
            ret = true;
            if (listItem) {
                this.indent(w, i);
                w.print("{");
                this.writeElement(c, w, i + 1, listItem);
            } else {
                this.writeElement(c, w, i, listItem);
            }
            if (listItem) {
                this.indent(w, i);
                w.print("}");
            }
            if (!iter.hasNext()) continue;
            w.print(",");
        }
        return ret;
    }

    private boolean isBoolean(String ename, String s) {
        if (this.stringElementNames.contains(ename)) {
            return false;
        }
        return Boolean.TRUE.toString().equals(s) || Boolean.FALSE.toString().equals(s);
    }

    private boolean isNumeric(String ename, String s) {
        if (this.stringElementNames.contains(ename)) {
            return false;
        }
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException nope) {
            return false;
        }
    }

    private void indent(PrintWriter pw, int amt) {
        if (this.fmt != null) {
            pw.print(this.fmt.getLineSeparator());
            for (int i = 0; i < amt; ++i) {
                pw.print(this.fmt.getIndent());
            }
        } else {
            pw.print(" ");
        }
    }
}

