/*
 * Decompiled with CFR 0.152.
 */
package org.opencadc.persist;

import ca.nrc.cadc.auth.NumericPrincipal;
import ca.nrc.cadc.date.DateUtil;
import ca.nrc.cadc.util.HexUtil;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.opencadc.persist.PrimitiveWrapper;

public abstract class Entity {
    private static final Logger log = Logger.getLogger(Entity.class);
    private final String localPackage;
    public static boolean MCS_DEBUG = false;
    private final boolean digestFieldNames;
    private final boolean digestFieldNamesLowerCase;
    private final boolean truncateDateToSec;
    private UUID id;
    private Date lastModified;
    private URI metaChecksum;
    public URI metaProducer;

    static final void assertNotNull(Class caller, String name, Object test) throws IllegalArgumentException {
        if (test == null) {
            throw new IllegalArgumentException("invalid " + caller.getSimpleName() + "." + name + ": null");
        }
    }

    @Deprecated
    protected Entity(boolean truncateDateToSec) {
        this(truncateDateToSec, false, false);
    }

    @Deprecated
    protected Entity(UUID id, boolean truncateDateToSec) {
        this(id, truncateDateToSec, false, false);
    }

    protected Entity(boolean truncateDateToSec, boolean digestFieldNames) {
        this(truncateDateToSec, digestFieldNames, false);
    }

    protected Entity(UUID id, boolean truncateDateToSec, boolean digestFieldNames) {
        this(id, truncateDateToSec, digestFieldNames, false);
    }

    protected Entity(boolean truncateDateToSec, boolean digestFieldNames, boolean digestFieldNamesLowerCase) {
        this(UUID.randomUUID(), truncateDateToSec, digestFieldNames, digestFieldNamesLowerCase);
    }

    protected Entity(UUID id, boolean truncateDateToSec, boolean digestFieldNames, boolean digestFieldNamesLowerCase) {
        Entity.assertNotNull(Entity.class, "id", id);
        this.id = id;
        this.truncateDateToSec = truncateDateToSec;
        this.digestFieldNames = digestFieldNames;
        this.digestFieldNamesLowerCase = digestFieldNamesLowerCase;
        this.localPackage = this.getClass().getPackage().getName();
    }

    public UUID getID() {
        return this.id;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public URI getMetaChecksum() {
        return this.metaChecksum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof Entity) {
            Entity a = (Entity)o;
            return this.id.equals(a.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        sb.append(this.id).append(",").append(this.metaChecksum).append(",");
        if (this.lastModified != null) {
            DateFormat df = DateUtil.getDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", DateUtil.UTC);
            sb.append(df.format(this.lastModified));
        } else {
            sb.append(this.lastModified);
        }
        sb.append("]");
        return sb.toString();
    }

    public URI computeMetaChecksum(MessageDigest digest) {
        try {
            MessageDigestWrapper mdw = new MessageDigestWrapper(digest);
            this.calcMetaChecksum(this.getClass(), this, mdw);
            if (MCS_DEBUG) {
                log.debug((Object)("computeMetaChecksum: " + mdw.getNumBytes() + " bytes"));
            }
            byte[] metaChecksumBytes = digest.digest();
            String hexMetaChecksum = HexUtil.toHex(metaChecksumBytes);
            String alg = digest.getAlgorithm().toLowerCase();
            return new URI(alg, hexMetaChecksum, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unable to create metadata checksum URI for " + this.getClass().getName(), e);
        }
    }

    protected final void calcMetaChecksum(Class c, Object o, MessageDigestWrapper digest) {
        try {
            if (o instanceof Entity) {
                Entity ce = (Entity)o;
                digest.update(this.primitiveValueToBytes(ce.id, "Entity.id"));
                if (ce.metaProducer != null) {
                    digest.update(this.primitiveValueToBytes(ce.metaProducer, "Entity.metaProducer"));
                    if (this.digestFieldNames) {
                        digest.update(this.primitiveValueToBytes("Entity.metaProducer", "Entity.metaProducer"));
                    }
                }
            }
            SortedSet<Field> fields = Entity.getStateFields(c);
            for (Field f : fields) {
                String cf = f.getDeclaringClass().getSimpleName() + "." + f.getName();
                f.setAccessible(true);
                Object fo = f.get(o);
                if (fo != null) {
                    Class<?> ac = fo.getClass();
                    if (ac.isEnum() || PrimitiveWrapper.class.isAssignableFrom(ac)) {
                        try {
                            log.warn((Object)("unwrap: " + ac.getSimpleName() + ".getValue()"));
                            Method m = ac.getMethod("getValue", new Class[0]);
                            Object val = m.invoke(fo, new Object[0]);
                            digest.update(this.primitiveValueToBytes(val, cf));
                            if (!this.digestFieldNames) continue;
                            digest.update(this.fieldNameToBytes(cf));
                            continue;
                        }
                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                            throw new RuntimeException("BUG - enum " + ac.getName() + " does not have getValue()", ex);
                        }
                    }
                    if (this.isDataModelClass(ac)) {
                        int num = digest.getNumBytes();
                        this.calcMetaChecksum(ac, fo, digest);
                        if (!this.digestFieldNames || num >= digest.getNumBytes()) continue;
                        digest.update(this.fieldNameToBytes(cf));
                        continue;
                    }
                    if (fo instanceof Collection) {
                        Collection stuff = (Collection)fo;
                        if (stuff.isEmpty()) continue;
                        for (Object co : stuff) {
                            Class<?> cc = co.getClass();
                            if (cc.isEnum() || PrimitiveWrapper.class.isAssignableFrom(cc)) {
                                try {
                                    Method m = cc.getMethod("getValue", new Class[0]);
                                    Object val = m.invoke(co, new Object[0]);
                                    digest.update(this.primitiveValueToBytes(val, cf));
                                    continue;
                                }
                                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                                    throw new RuntimeException("BUG", ex);
                                }
                            }
                            if (this.isDataModelClass(cc)) {
                                this.calcMetaChecksum(cc, co, digest);
                                continue;
                            }
                            digest.update(this.primitiveValueToBytes(co, cf));
                        }
                        if (!this.digestFieldNames) continue;
                        digest.update(this.fieldNameToBytes(cf));
                        continue;
                    }
                    digest.update(this.primitiveValueToBytes(fo, cf));
                    if (!this.digestFieldNames) continue;
                    digest.update(this.fieldNameToBytes(cf));
                    continue;
                }
                if (!MCS_DEBUG) continue;
                log.debug((Object)("skip null: " + cf));
            }
        }
        catch (IllegalAccessException bug) {
            throw new RuntimeException("Unable to calculate metaChecksum for class " + c.getName(), bug);
        }
    }

    protected boolean isDataModelClass(Class c) {
        if (c.isPrimitive() || c.isArray()) {
            return false;
        }
        String pname = c.getPackage().getName();
        return pname.startsWith(this.localPackage);
    }

    public static SortedSet<Field> getStateFields(Class c) throws IllegalAccessException {
        Field[] fields;
        TreeSet<Field> ret = new TreeSet<Field>(new FieldComparator());
        for (Field f : fields = c.getDeclaredFields()) {
            int m = f.getModifiers();
            boolean inc = true;
            inc = inc && !Modifier.isTransient(m);
            inc = inc && !Modifier.isStatic(m);
            inc = inc && !Entity.isChildCollection(f);
            boolean bl = inc = inc && !Entity.isChildEntity(f);
            if (!inc) continue;
            ret.add(f);
        }
        for (Class sc = c.getSuperclass(); sc != null && !Entity.class.equals(sc); sc = sc.getSuperclass()) {
            ret.addAll(Entity.getStateFields(sc));
        }
        return ret;
    }

    public static SortedSet<Field> getChildFields(Class c) throws IllegalAccessException {
        Field[] fields;
        TreeSet<Field> ret = new TreeSet<Field>(new FieldComparator());
        for (Field f : fields = c.getDeclaredFields()) {
            int m = f.getModifiers();
            if (Modifier.isTransient(m) || Modifier.isStatic(m) || !Entity.isChildCollection(f) && !Entity.isChildEntity(f)) continue;
            ret.add(f);
        }
        for (Class sc = c.getSuperclass(); sc != null && !Entity.class.equals(sc); sc = sc.getSuperclass()) {
            ret.addAll(Entity.getChildFields(sc));
        }
        return ret;
    }

    public static boolean isChildEntity(Field f) throws IllegalAccessException {
        return Entity.class.isAssignableFrom(f.getType());
    }

    public static boolean isChildCollection(Field f) throws IllegalAccessException {
        Class genType;
        ParameterizedType pt;
        Type[] ptypes;
        return Collection.class.isAssignableFrom(f.getType()) && f.getGenericType() instanceof ParameterizedType && (ptypes = (pt = (ParameterizedType)f.getGenericType()).getActualTypeArguments())[0] instanceof Class && Entity.class.isAssignableFrom(genType = (Class)ptypes[0]);
    }

    protected byte[] primitiveValueToBytes(Object o, String name) {
        byte[] ret = null;
        if (o instanceof Byte) {
            ret = HexUtil.toBytes((Byte)o);
        } else if (o instanceof Short) {
            ret = HexUtil.toBytes((Short)o);
        } else if (o instanceof Integer) {
            ret = HexUtil.toBytes((Integer)o);
        } else if (o instanceof Long) {
            ret = HexUtil.toBytes((Long)o);
        } else if (o instanceof Boolean) {
            Boolean b = (Boolean)o;
            ret = b.booleanValue() ? HexUtil.toBytes((byte)1) : HexUtil.toBytes((byte)0);
        } else if (o instanceof Date) {
            Date date = (Date)o;
            long sec = date.getTime();
            if (this.truncateDateToSec) {
                sec = date.getTime() / 1000L;
            }
            ret = HexUtil.toBytes(sec);
        } else if (o instanceof Float) {
            ret = HexUtil.toBytes(Float.floatToIntBits(((Float)o).floatValue()));
        } else if (o instanceof Double) {
            ret = HexUtil.toBytes(Double.doubleToLongBits((Double)o));
        } else if (o instanceof String) {
            try {
                ret = ((String)o).trim().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException("BUG: failed to encode String in UTF-8", ex);
            }
        } else if (o instanceof URI) {
            try {
                ret = ((URI)o).toASCIIString().trim().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException("BUG: failed to encode String in UTF-8", ex);
            }
        } else if (o instanceof UUID) {
            UUID uuid = (UUID)o;
            byte[] msb = HexUtil.toBytes(uuid.getMostSignificantBits());
            byte[] lsb = HexUtil.toBytes(uuid.getLeastSignificantBits());
            ret = new byte[16];
            System.arraycopy(msb, 0, ret, 0, 8);
            System.arraycopy(lsb, 0, ret, 8, 8);
        } else if (o instanceof NumericPrincipal) {
            NumericPrincipal np = (NumericPrincipal)o;
            UUID uuid = np.getUUID();
            byte[] msb = HexUtil.toBytes(uuid.getMostSignificantBits());
            byte[] lsb = HexUtil.toBytes(uuid.getLeastSignificantBits());
            ret = new byte[16];
            System.arraycopy(msb, 0, ret, 0, 8);
            System.arraycopy(lsb, 0, ret, 8, 8);
        } else if (o instanceof byte[]) {
            ret = (byte[])o;
        } else if (o instanceof double[]) {
            double[] da = (double[])o;
            ret = new byte[8 * da.length];
            for (int i = 0; i < da.length; ++i) {
                byte[] b = HexUtil.toBytes(Double.doubleToLongBits(da[i]));
                System.arraycopy(b, 0, ret, i * 8, 8);
            }
        }
        if (ret != null) {
            if (MCS_DEBUG) {
                String dfn = "";
                if (o == name) {
                    dfn = " digest-field-name";
                }
                log.debug((Object)(o.getClass().getSimpleName() + " " + name + " = " + o.toString() + " " + ret.length + " bytes" + dfn));
            }
            return ret;
        }
        throw new UnsupportedOperationException("unexpected primitive/value type: " + o.getClass().getName());
    }

    protected byte[] fieldNameToBytes(String name) {
        String val = name.trim();
        if (this.digestFieldNamesLowerCase) {
            val = val.toLowerCase();
        }
        byte[] ret = null;
        try {
            ret = val.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("BUG: failed to encode String in UTF-8", ex);
        }
        if (ret != null) {
            if (MCS_DEBUG) {
                String dfn = " digest-field-name";
                log.debug((Object)(val.getClass().getSimpleName() + " " + name + " = " + val + " " + ret.length + " bytes" + dfn));
            }
            return ret;
        }
        throw new RuntimeException("BUG: null field name");
    }

    private static class FieldComparator
    implements Comparator<Field> {
        private FieldComparator() {
        }

        @Override
        public int compare(Field o1, Field o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    public static class MessageDigestWrapper {
        private MessageDigest digest;
        private int numBytes = 0;

        public MessageDigestWrapper(MessageDigest digest) {
            this.digest = digest;
        }

        public void update(byte[] b) {
            this.digest.update(b);
            this.numBytes += b.length;
        }

        public int getNumBytes() {
            return this.numBytes;
        }
    }
}

