/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.uws;

import ca.nrc.cadc.uws.ErrorSummary;
import ca.nrc.cadc.uws.Job;
import ca.nrc.cadc.uws.JobAttribute;
import ca.nrc.cadc.uws.JobInfo;
import ca.nrc.cadc.uws.Parameter;
import ca.nrc.cadc.uws.Result;
import ca.nrc.cadc.uws.UWS;
import ca.nrc.cadc.xml.XmlUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class JobWriter {
    private static Logger log = Logger.getLogger(JobWriter.class);
    private DateFormat dateFormat = UWS.getDateFormat();

    protected void writeDocument(Element root, Writer writer) throws IOException {
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getPrettyFormat());
        Document document = new Document(root);
        outputter.output(document, writer);
    }

    public void write(Job job, OutputStream out) throws IOException {
        this.write(job, new OutputStreamWriter(out));
    }

    public void write(Job job, Writer writer) throws IOException {
        Element root = this.getRootElement(job);
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getPrettyFormat());
        Document document = new Document(root);
        outputter.output(document, writer);
    }

    public void writeParametersDoc(List<Parameter> params, OutputStream out) throws IOException {
        this.writeParametersDoc(params, new OutputStreamWriter(out));
    }

    public void writeParametersDoc(List<Parameter> params, Writer writer) throws IOException {
        Element root = this.getParametersRootElement(params);
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getPrettyFormat());
        Document document = new Document(root);
        outputter.output(document, writer);
    }

    public void writeResultsDoc(List<Result> params, OutputStream out) throws IOException {
        this.writeResultsDoc(params, new OutputStreamWriter(out));
    }

    public void writeResultsDoc(List<Result> results, Writer writer) throws IOException {
        Element root = this.getResultsRootElement(results);
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getPrettyFormat());
        Document document = new Document(root);
        outputter.output(document, writer);
    }

    public static Element getJob() {
        Element element = new Element(JobAttribute.JOB.getValue(), UWS.NS);
        element.addNamespaceDeclaration(UWS.NS);
        element.addNamespaceDeclaration(UWS.XLINK_NS);
        return element;
    }

    public Element getParametersRootElement(List<Parameter> params) {
        Element root = this.getParameters(params);
        root.addNamespaceDeclaration(UWS.NS);
        root.addNamespaceDeclaration(UWS.XLINK_NS);
        root.setAttribute(JobAttribute.VERSION.getValue(), "1.1");
        return root;
    }

    public Element getResultsRootElement(List<Result> results) {
        Element root = this.getResults(results);
        root.addNamespaceDeclaration(UWS.NS);
        root.addNamespaceDeclaration(UWS.XLINK_NS);
        root.setAttribute(JobAttribute.VERSION.getValue(), "1.1");
        return root;
    }

    public Element getRootElement(Job job) {
        Element jobInfo;
        Element root = new Element(JobAttribute.JOB.getValue(), UWS.NS);
        root.addNamespaceDeclaration(UWS.NS);
        root.addNamespaceDeclaration(UWS.XLINK_NS);
        root.setAttribute(JobAttribute.VERSION.getValue(), "1.1");
        root.addContent((Content)this.getJobId(job));
        root.addContent((Content)this.getRunId(job));
        root.addContent((Content)this.getOwnerId(job));
        root.addContent((Content)this.getPhase(job));
        root.addContent((Content)this.getQuote(job));
        Element creationTime = this.getCreationTime(job);
        if (creationTime != null) {
            root.addContent((Content)creationTime);
        }
        root.addContent((Content)this.getStartTime(job));
        root.addContent((Content)this.getEndTime(job));
        root.addContent((Content)this.getExecutionDuration(job));
        root.addContent((Content)this.getDestruction(job));
        root.addContent((Content)this.getParameters(job.getParameterList()));
        root.addContent((Content)this.getResults(job.getResultsList()));
        Element errorSummary = this.getErrorSummary(job);
        if (errorSummary != null) {
            root.addContent((Content)errorSummary);
        }
        if ((jobInfo = this.getJobInfo(job)) != null) {
            root.addContent((Content)jobInfo);
        }
        return root;
    }

    public Element getJobId(Job job) {
        Element element = new Element(JobAttribute.JOB_ID.getValue(), UWS.NS);
        element.addContent(job.getID());
        return element;
    }

    public Element getJobRef(String host, Job job) {
        Element element = new Element(JobAttribute.JOB_REF.getValue(), UWS.NS);
        element.setAttribute("id", job.getID());
        element.setAttribute("xlink:href", host + job.getRequestPath() + "/" + job.getID());
        return element;
    }

    public Element getRunId(Job job) {
        Element element = new Element(JobAttribute.RUN_ID.getValue(), UWS.NS);
        element.addContent(job.getRunID());
        return element;
    }

    public Element getOwnerId(Job job) {
        Element element = new Element(JobAttribute.OWNER_ID.getValue(), UWS.NS);
        if (job.ownerDisplay != null) {
            element.addContent(job.ownerDisplay);
        } else {
            element.setAttribute("nil", "true", UWS.XSI_NS);
        }
        return element;
    }

    public Element getPhase(Job job) {
        Element element = new Element(JobAttribute.EXECUTION_PHASE.getValue(), UWS.NS);
        element.addContent(job.getExecutionPhase().toString());
        return element;
    }

    public Element getQuote(Job job) {
        Element element = new Element(JobAttribute.QUOTE.getValue(), UWS.NS);
        Date date = job.getQuote();
        if (date == null) {
            element.setAttribute("nil", "true", UWS.XSI_NS);
        } else {
            element.addContent(this.dateFormat.format(date));
        }
        return element;
    }

    public Element getStartTime(Job job) {
        Element element = new Element(JobAttribute.START_TIME.getValue(), UWS.NS);
        Date date = job.getStartTime();
        if (date == null) {
            element.setAttribute("nil", "true", UWS.XSI_NS);
        } else {
            element.addContent(this.dateFormat.format(date));
        }
        return element;
    }

    public Element getEndTime(Job job) {
        Element element = new Element(JobAttribute.END_TIME.getValue(), UWS.NS);
        Date date = job.getEndTime();
        if (date == null) {
            element.setAttribute("nil", "true", UWS.XSI_NS);
        } else {
            element.addContent(this.dateFormat.format(date));
        }
        return element;
    }

    public Element getCreationTime(Job job) {
        Date date = job.getCreationTime();
        if (date != null) {
            Element element = new Element(JobAttribute.CREATION_TIME.getValue(), UWS.NS);
            element.addContent(this.dateFormat.format(date));
            return element;
        }
        return null;
    }

    public Element getExecutionDuration(Job job) {
        Element element = new Element(JobAttribute.EXECUTION_DURATION.getValue(), UWS.NS);
        element.addContent(Long.toString(job.getExecutionDuration()));
        return element;
    }

    public Element getDestruction(Job job) {
        Element element = new Element(JobAttribute.DESTRUCTION_TIME.getValue(), UWS.NS);
        Date date = job.getDestructionTime();
        if (date == null) {
            element.setAttribute("nil", "true", UWS.XSI_NS);
        } else {
            element.addContent(this.dateFormat.format(date));
        }
        return element;
    }

    public Element getParameters(List<Parameter> params) {
        Element element = new Element(JobAttribute.PARAMETERS.getValue(), UWS.NS);
        for (Parameter parameter : params) {
            Element e = new Element(JobAttribute.PARAMETER.getValue(), UWS.NS);
            e.setAttribute("id", parameter.getName());
            e.addContent(parameter.getValue());
            element.addContent((Content)e);
        }
        return element;
    }

    public Element getResults(List<Result> results) {
        Element element = new Element(JobAttribute.RESULTS.getValue(), UWS.NS);
        for (Result result : results) {
            Element e = new Element(JobAttribute.RESULT.getValue(), UWS.NS);
            e.setAttribute("id", result.getName());
            e.setAttribute("href", result.getURI().toASCIIString(), UWS.XLINK_NS);
            element.addContent((Content)e);
        }
        return element;
    }

    public Element getErrorSummary(Job job) {
        Element eleErrorSummary = null;
        ErrorSummary es = job.getErrorSummary();
        if (es != null) {
            eleErrorSummary = new Element(JobAttribute.ERROR_SUMMARY.getValue(), UWS.NS);
            eleErrorSummary.setAttribute("type", es.getErrorType().toString().toLowerCase());
            eleErrorSummary.setAttribute("hasDetail", Boolean.toString(es.getHasDetail()));
            Element eleMessage = new Element(JobAttribute.ERROR_SUMMARY_MESSAGE.getValue(), UWS.NS);
            eleMessage.addContent(job.getErrorSummary().getSummaryMessage());
            eleErrorSummary.addContent((Content)eleMessage);
        }
        return eleErrorSummary;
    }

    public Element getJobInfo(Job job) {
        Element element = null;
        JobInfo jobInfo = job.getJobInfo();
        if (jobInfo != null && jobInfo.getContent() != null && jobInfo.getValid() != null && jobInfo.getValid().booleanValue()) {
            element = new Element(JobAttribute.JOB_INFO.getValue(), UWS.NS);
            try {
                Document doc = XmlUtil.buildDocument((String)jobInfo.getContent());
                element.addContent((Content)doc.getRootElement().detach());
            }
            catch (Exception e) {
                element = null;
            }
        }
        return element;
    }
}

