/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vosi;

import ca.nrc.cadc.date.DateUtil;
import ca.nrc.cadc.vosi.Util;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class Availability {
    private final boolean available;
    public String note;
    public Date upSince;
    public Date downAt;
    public Date backAt;
    public String clientIP;

    public Availability(boolean available) {
        this.available = available;
    }

    public Availability(boolean available, String note) {
        this.available = available;
        this.note = note;
    }

    public boolean isAvailable() {
        return this.available;
    }

    @Deprecated
    public static Document toXmlDocument(Availability avail) {
        DateFormat df = DateUtil.getDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss.SSS", (TimeZone)DateUtil.UTC);
        Namespace vosi = Namespace.getNamespace((String)"vosi", (String)"http://www.ivoa.net/xml/VOSIAvailability/v1.0");
        Element eleAvailability = new Element("availability", vosi);
        Util.addChild(eleAvailability, vosi, "available", Boolean.toString(avail.isAvailable()));
        if (avail.upSince != null) {
            Util.addChild(eleAvailability, vosi, "upSince", df.format(avail.upSince));
        }
        if (avail.downAt != null) {
            Util.addChild(eleAvailability, vosi, "downAt", df.format(avail.downAt));
        }
        if (avail.backAt != null) {
            Util.addChild(eleAvailability, vosi, "backAt", df.format(avail.backAt));
        }
        if (avail.note != null) {
            Util.addChild(eleAvailability, vosi, "note", avail.note);
        }
        if (avail.clientIP != null) {
            eleAvailability.addContent((Content)new Comment(String.format("<clientip>%s</clientip>", avail.clientIP)));
        }
        Document document = new Document();
        document.addContent((Content)eleAvailability);
        return document;
    }

    @Deprecated
    public static Availability fromXmlDocument(Document doc) throws ParseException {
        Namespace vosi = Namespace.getNamespace((String)"vosi", (String)"http://www.ivoa.net/xml/VOSIAvailability/v1.0");
        Element availability = doc.getRootElement();
        if (!availability.getName().equals("availability")) {
            throw new IllegalArgumentException("missing root element 'availability'");
        }
        Element elemAvailable = availability.getChild("available", vosi);
        if (elemAvailable == null) {
            throw new IllegalArgumentException("missing element 'available'");
        }
        boolean available = elemAvailable.getText().equalsIgnoreCase("true");
        Availability ret = new Availability(available);
        DateFormat df = DateUtil.getDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss.SSS", (TimeZone)DateUtil.UTC);
        Element elemUpSince = availability.getChild("upSince", vosi);
        ret.upSince = Availability.safeParseDate(elemUpSince, df);
        Element elemDownAt = availability.getChild("downAt", vosi);
        ret.downAt = Availability.safeParseDate(elemDownAt, df);
        Element elemBackAt = availability.getChild("backAt", vosi);
        ret.backAt = Availability.safeParseDate(elemBackAt, df);
        Element elemNote = availability.getChild("note", vosi);
        if (elemNote != null) {
            ret.note = elemNote.getText();
        }
        for (Content c : availability.getContent()) {
            Comment com;
            String s;
            if (!(c instanceof Comment) || !(s = (com = (Comment)c).getText()).startsWith("<clientip>") || !s.endsWith("/clientip>")) continue;
            ret.clientIP = s.substring(10, s.length() - 11);
        }
        return ret;
    }

    private static Date safeParseDate(Element e, DateFormat df) throws ParseException {
        if (e == null || e.getTextTrim().isEmpty()) {
            return null;
        }
        return df.parse(e.getTextTrim());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Availability[");
        sb.append("available=").append(this.available);
        if (this.upSince != null) {
            sb.append(",upSince=").append(this.upSince);
        }
        if (this.downAt != null) {
            sb.append(",downAt=").append(this.downAt);
        }
        if (this.backAt != null) {
            sb.append(",backAt=").append(this.backAt);
        }
        if (this.note != null) {
            sb.append(",note=").append(this.note);
        }
        if (this.clientIP != null) {
            sb.append(",clientip=").append(this.clientIP);
        }
        sb.append("]");
        return sb.toString();
    }
}

