/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vosi;

import ca.nrc.cadc.auth.AuthMethod;
import ca.nrc.cadc.net.HttpGet;
import ca.nrc.cadc.reg.Standards;
import ca.nrc.cadc.reg.XMLConstants;
import ca.nrc.cadc.reg.client.RegistryClient;
import ca.nrc.cadc.vosi.Availability;
import ca.nrc.cadc.xml.XmlUtil;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.JDOMException;

public class AvailabilityClient {
    private static Logger log = Logger.getLogger(AvailabilityClient.class);
    public static final String AVAILABILITY_ENDPOINT = "/availability";
    public static final String MIN_DETAIL_PARAMETER = "?detail=min";
    public static final int DEFAULT_CONNECTION_TIMEOUT = 6000;
    public static final int DEFAULT_READ_TIMEOUT = 12000;
    public static final int DEFAULT_MAX_RETRIES = 0;
    public static final int MIN_DETAIL_READ_TIMEOUT = 2000;
    public static final Map<String, String> AVAIL_SCHEMA_MAP = new TreeMap<String, String>();
    private final URI resourceID;
    private final boolean minDetail;
    private final RegistryClient reg = new RegistryClient();

    public AvailabilityClient(URI resourceID) {
        if (resourceID == null) {
            throw new IllegalArgumentException("resourceID is null");
        }
        this.resourceID = resourceID;
        this.minDetail = false;
    }

    public AvailabilityClient(URI resourceID, boolean minDetail) {
        if (resourceID == null) {
            throw new IllegalArgumentException("resourceID is null");
        }
        this.resourceID = resourceID;
        this.minDetail = minDetail;
    }

    @Deprecated
    public AvailabilityClient() {
        this.resourceID = null;
        this.minDetail = false;
    }

    public Availability getAvailability() {
        if (this.resourceID == null) {
            throw new IllegalStateException("caller used deprecated constructor - must use deprecated getAvailability(URL)");
        }
        URL avail = this.reg.getServiceURL(this.resourceID, Standards.VOSI_AVAILABILITY, AuthMethod.ANON);
        return this.doit(avail);
    }

    @Deprecated
    public Availability getAvailability(URL baseURL) {
        if (baseURL == null) {
            throw new IllegalArgumentException("null URL");
        }
        try {
            URL availabilityURL = new URL(baseURL.toExternalForm() + AVAILABILITY_ENDPOINT);
            return this.doit(availabilityURL);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("invalid baseURL: cannot append /availability", ex);
        }
    }

    private Availability doit(URL availabilityURL) {
        Availability ret;
        try {
            if (this.minDetail) {
                availabilityURL = new URL(availabilityURL.toString() + MIN_DETAIL_PARAMETER);
            }
            log.debug((Object)("GET " + availabilityURL));
            HttpGet get = new HttpGet(availabilityURL, true);
            get.setConnectionTimeout(6000);
            get.setMaxRetries(0);
            if (this.minDetail) {
                get.setReadTimeout(2000);
            } else {
                get.setReadTimeout(12000);
            }
            get.prepare();
            log.debug((Object)("GET " + availabilityURL + " code: " + get.getResponseCode()));
            if (get.getResponseCode() == 200) {
                if (this.minDetail) {
                    return new Availability(true);
                }
                Document xml = XmlUtil.buildDocument((InputStream)get.getInputStream(), AVAIL_SCHEMA_MAP);
                ret = Availability.fromXmlDocument(xml);
            } else {
                ret = this.getFalseAvailability("unexpected response code (" + get.getResponseCode() + ") from " + availabilityURL.toExternalForm());
            }
        }
        catch (JDOMException ex) {
            ret = this.getFalseAvailability("Error parsing availability from " + availabilityURL + " reason: " + ex.getMessage());
        }
        catch (Exception ex) {
            ret = this.getFalseAvailability("Error getting availability from " + availabilityURL + " reason: " + ex.getMessage());
        }
        return ret;
    }

    protected Availability getFalseAvailability(String msg) {
        return new Availability(false, msg);
    }

    static {
        AVAIL_SCHEMA_MAP.putAll(XMLConstants.SCHEMA_MAP);
        String localURL = XmlUtil.getResourceUrlString((String)"VOSIAvailability-v1.0.xsd", XMLConstants.class);
        AVAIL_SCHEMA_MAP.put("http://www.ivoa.net/xml/VOSIAvailability/v1.0", localURL);
    }
}

