/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vosi;

import ca.nrc.cadc.auth.AuthenticationUtil;
import ca.nrc.cadc.auth.IdentityManager;
import ca.nrc.cadc.log.ServletLogInfo;
import ca.nrc.cadc.net.NetUtil;
import ca.nrc.cadc.util.InvalidConfigException;
import ca.nrc.cadc.util.MultiValuedProperties;
import ca.nrc.cadc.util.PropertiesReader;
import ca.nrc.cadc.util.StringUtil;
import ca.nrc.cadc.vosi.Availability;
import ca.nrc.cadc.vosi.AvailabilityPlugin;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class AvailabilityServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(AvailabilityServlet.class);
    private static final long serialVersionUID = 201003131300L;
    private static final String AVAILABILITY_PROPERTIES = "cadc-vosi.properties";
    private static final String MODE_KEY = "startupMode";
    private static final String USERS_PROPERTY = "user";
    private String pluginClassName;
    private String appName;

    public void init(ServletConfig config) throws ServletException {
        this.appName = config.getServletContext().getContextPath().substring(1).replaceAll("/", "-");
        this.pluginClassName = config.getInitParameter(AvailabilityPlugin.class.getName());
        log.info((Object)("application: " + this.appName + " plugin impl: " + this.pluginClassName));
        MultiValuedProperties mvp = this.getAvailabilityProperties();
        String startupMode = mvp.getFirstPropertyValue(MODE_KEY);
        if (startupMode != null) {
            AvailabilityPlugin ap = this.loadPlugin();
            ap.setState(startupMode);
        }
    }

    private AvailabilityPlugin loadPlugin() throws InvalidConfigException {
        try {
            Class<?> wsClass = Class.forName(this.pluginClassName);
            AvailabilityPlugin ap = (AvailabilityPlugin)wsClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            ap.setAppName(this.appName);
            log.debug((Object)("loaded: " + wsClass));
            return ap;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new InvalidConfigException("failed to load AvailabilityPlugin: " + this.pluginClassName, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean started = false;
        ServletLogInfo logInfo = new ServletLogInfo(request);
        long start = System.currentTimeMillis();
        try {
            Subject subject = AuthenticationUtil.getSubject((HttpServletRequest)request, (boolean)false);
            logInfo.setSubject(subject);
            log.info((Object)logInfo.start());
            AvailabilityPlugin ap = this.loadPlugin();
            String detail = request.getParameter("detail");
            if (detail != null && detail.equals("min")) {
                if (ap.heartbeat()) {
                    response.setStatus(200);
                } else {
                    response.setStatus(503);
                }
            } else {
                Availability avail = ap.getStatus();
                avail.clientIP = NetUtil.getClientIP((HttpServletRequest)request);
                Document document = Availability.toXmlDocument(avail);
                XMLOutputter xop = new XMLOutputter(Format.getPrettyFormat());
                started = true;
                response.setContentType("text/xml");
                xop.output(document, (OutputStream)response.getOutputStream());
            }
            logInfo.setSuccess(true);
        }
        catch (Exception ex) {
            log.error((Object)"BUG", (Throwable)ex);
            if (!started) {
                response.sendError(503, ex.getMessage());
            }
            logInfo.setSuccess(false);
            logInfo.setMessage(ex.toString());
        }
        finally {
            logInfo.setElapsedTime(Long.valueOf(System.currentTimeMillis() - start));
            log.info((Object)logInfo.end());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletLogInfo logInfo = new ServletLogInfo(request);
        long start = System.currentTimeMillis();
        try {
            Subject subject = AuthenticationUtil.getSubject((HttpServletRequest)request, (boolean)false);
            logInfo.setSubject(subject);
            log.info((Object)logInfo.start());
            AvailabilityPlugin ap = this.loadPlugin();
            IdentityManager im = AuthenticationUtil.getIdentityManager();
            String caller = im.toDisplayString(subject);
            if (this.authorized(subject)) {
                String state = request.getParameter("state");
                ap.setState(state);
                log.info((Object)("WebService state change by " + caller + " [OK]"));
            } else {
                log.warn((Object)("WebService state change by " + caller + " [DENIED]"));
            }
            response.sendRedirect(request.getRequestURL().toString());
            logInfo.setSuccess(true);
        }
        catch (IllegalArgumentException ex) {
            response.setStatus(400);
            response.setHeader("content-type", "text/plain");
            PrintWriter w = response.getWriter();
            w.println(ex.getMessage());
            w.close();
            logInfo.setSuccess(true);
            logInfo.setMessage(ex.toString());
        }
        catch (Throwable t) {
            log.error((Object)"BUG", t);
            response.sendError(503, t.getMessage());
            logInfo.setSuccess(false);
            logInfo.setMessage(t.toString());
        }
        finally {
            logInfo.setElapsedTime(Long.valueOf(System.currentTimeMillis() - start));
            log.info((Object)logInfo.end());
        }
    }

    private boolean authorized(Subject caller) {
        if (caller != null) {
            Set<Principal> authorizedPrincipals = this.getAuthorizedPrincipals();
            for (Principal cp : caller.getPrincipals()) {
                for (Principal ap : authorizedPrincipals) {
                    log.debug((Object)("authorize?  " + ap.getName() + " vs " + cp.getName()));
                    if (!AuthenticationUtil.equals((Principal)ap, (Principal)cp)) continue;
                    log.debug((Object)("Authorized Principal: " + ap.getName()));
                    return true;
                }
            }
        }
        return false;
    }

    private Set<Principal> getAuthorizedPrincipals() {
        HashSet<Principal> authorizedPrincipals = new HashSet<Principal>();
        try {
            MultiValuedProperties mvp = this.getAvailabilityProperties();
            List authorizedUsers = mvp.getProperty(USERS_PROPERTY);
            for (String authorizedUser : authorizedUsers) {
                if (!StringUtil.hasLength((String)authorizedUser)) continue;
                authorizedPrincipals.add(new X500Principal(authorizedUser));
            }
        }
        catch (IllegalArgumentException e) {
            log.debug((Object)"No authorized users configured");
        }
        log.debug((Object)("configured aithorized: " + authorizedPrincipals.size()));
        return authorizedPrincipals;
    }

    private MultiValuedProperties getAvailabilityProperties() {
        PropertiesReader reader = new PropertiesReader(AVAILABILITY_PROPERTIES);
        if (!reader.canRead()) {
            return new MultiValuedProperties();
        }
        return reader.getAllProperties();
    }
}

