/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vosi;

import ca.nrc.cadc.auth.AuthMethod;
import ca.nrc.cadc.auth.AuthenticationUtil;
import ca.nrc.cadc.auth.IdentityManager;
import ca.nrc.cadc.auth.NotAuthenticatedException;
import ca.nrc.cadc.net.ResourceNotFoundException;
import ca.nrc.cadc.reg.AccessURL;
import ca.nrc.cadc.reg.Capabilities;
import ca.nrc.cadc.reg.CapabilitiesWriter;
import ca.nrc.cadc.reg.Capability;
import ca.nrc.cadc.reg.Interface;
import ca.nrc.cadc.reg.Standards;
import ca.nrc.cadc.reg.client.LocalAuthority;
import ca.nrc.cadc.reg.client.RegistryClient;
import ca.nrc.cadc.rest.InlineContentHandler;
import ca.nrc.cadc.rest.RestAction;
import ca.nrc.cadc.rest.SyncOutput;
import ca.nrc.cadc.vosi.CapInitAction;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ListIterator;
import java.util.TreeSet;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;

public class CapGetAction
extends RestAction {
    private static final Logger log = Logger.getLogger(CapGetAction.class);
    protected boolean doTransform = true;

    protected String getServerImpl() {
        return CapInitAction.getVersion(this.componentID);
    }

    protected InlineContentHandler getInlineContentHandler() {
        return null;
    }

    public void doAction() throws Exception {
        AuthMethod am;
        if (CapInitAction.getAuthRequired(this.componentID) && ((am = AuthenticationUtil.getAuthMethod((Subject)AuthenticationUtil.getCurrentSubject())) == null || am.equals((Object)AuthMethod.ANON))) {
            throw new NotAuthenticatedException("permission denied");
        }
        Capabilities caps = CapInitAction.getTemplate(this.componentID);
        log.debug((Object)("transformAccessURL=" + this.doTransform));
        if (this.doTransform) {
            this.transform(caps);
        }
        this.doOutput(caps, this.syncOutput);
        this.logInfo.setSuccess(true);
    }

    private void transform(Capabilities caps) throws MalformedURLException {
        log.debug((Object)("context: " + this.syncInput.getContextPath()));
        log.debug((Object)("component: " + this.syncInput.getComponentPath()));
        boolean filterSecurityMethods = !"false".equals(this.initParams.get("filterSecurityMethods"));
        String hostname = new URL(this.syncInput.getRequestURI()).getHost();
        Capability cap = caps.findCapability(Standards.VOSI_CAPABILITIES);
        URL capURL = ((Interface)cap.getInterfaces().get(0)).getAccessURL().getURL();
        String capPath = capURL.getPath();
        String basePath = capURL.getPath().substring(0, capPath.indexOf("/capabilities"));
        Object actualPath = this.syncInput.getContextPath() + this.syncInput.getComponentPath();
        actualPath = ((String)actualPath).substring(0, ((String)actualPath).indexOf("/capabilities"));
        log.debug((Object)("transform: basePath in template: " + basePath + " actualPath: " + (String)actualPath));
        for (Capability c : caps.getCapabilities()) {
            for (Interface i : c.getInterfaces()) {
                AccessURL u = i.getAccessURL();
                URL url = u.getURL();
                String path = url.getPath();
                String npath = path.replace(basePath, (CharSequence)actualPath);
                URL nurl = new URL(url.getProtocol(), hostname, npath);
                u.setURL(nurl);
                log.debug((Object)("transform: " + url + " -> " + nurl));
                if (!filterSecurityMethods) continue;
                IdentityManager im = AuthenticationUtil.getIdentityManager();
                log.debug((Object)("IM: " + im.getClass().getName()));
                ListIterator iter = i.getSecurityMethods().listIterator();
                while (iter.hasNext()) {
                    URI sm = (URI)iter.next();
                    if (!im.getSecurityMethods().contains(sm)) {
                        log.debug((Object)("unsupported securityMethod: " + sm + " - REMOVE"));
                        iter.remove();
                        continue;
                    }
                    log.debug((Object)("supported securityMethod: " + sm + " - KEEP"));
                }
            }
        }
    }

    private void doOutput(Capabilities caps, SyncOutput out) throws IOException {
        out.setHeader("Content-Type", (Object)"text/xml");
        out.setCode(200);
        CapabilitiesWriter w = new CapabilitiesWriter();
        w.write(caps, this.syncOutput.getOutputStream());
    }

    private void injectAuthProviders(Capabilities caps) throws IOException {
        TreeSet<URI> sms = new TreeSet<URI>();
        for (Capability cap : caps.getCapabilities()) {
            for (Interface i : cap.getInterfaces()) {
                for (URI s : i.getSecurityMethods()) {
                    sms.add(s);
                }
            }
        }
        log.debug((Object)("found " + sms.size() + " unique SecurityMethod(s)"));
        if (sms.isEmpty()) {
            return;
        }
        LocalAuthority loc = new LocalAuthority();
        RegistryClient reg = new RegistryClient();
        for (URI sm : sms) {
            URI resourceID = loc.getServiceURI(sm.toASCIIString());
            try {
                if (resourceID != null) {
                    Capabilities srv = reg.getCapabilities(resourceID);
                    if (srv != null) {
                        Capability auth = srv.findCapability(sm);
                        if (auth != null) {
                            caps.getCapabilities().add(auth);
                            continue;
                        }
                        log.debug((Object)("not found: " + sm + " in " + resourceID));
                        continue;
                    }
                    log.debug((Object)("not found: " + resourceID + " capabilities"));
                    continue;
                }
                log.debug((Object)("not found: " + sm));
            }
            catch (ResourceNotFoundException ex) {
                log.warn((Object)("failed to find auth service: " + resourceID + "cause: " + ex));
            }
        }
    }
}

