/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vosi;

import ca.nrc.cadc.reg.Capabilities;
import ca.nrc.cadc.reg.CapabilitiesReader;
import ca.nrc.cadc.rest.InitAction;
import ca.nrc.cadc.rest.Version;
import ca.nrc.cadc.util.StringUtil;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class CapInitAction
extends InitAction {
    private static final Logger log = Logger.getLogger(CapInitAction.class);

    static Capabilities getTemplate(String componentID) {
        String jndiKey = componentID + ".cap-template";
        try {
            log.debug((Object)("retrieving capabilities template via JNDI: " + jndiKey));
            InitialContext initContext = new InitialContext();
            String tmpl = (String)initContext.lookup(jndiKey);
            CapabilitiesReader cr = new CapabilitiesReader(false);
            StringReader sr = new StringReader(tmpl);
            Capabilities caps = cr.read((Reader)sr);
            return caps;
        }
        catch (Exception ex) {
            throw new IllegalStateException("failed to find template via JNDI: init failed", ex);
        }
    }

    static boolean getAuthRequired(String componentID) {
        String jndiKey = componentID + ".authRequired";
        try {
            log.debug((Object)("retrieving authRequired via JNDI: " + jndiKey));
            InitialContext initContext = new InitialContext();
            Boolean authRequired = (Boolean)initContext.lookup(jndiKey);
            if (authRequired == null) {
                return false;
            }
            return authRequired;
        }
        catch (Exception ex) {
            throw new IllegalStateException("failed to find authRequired via JNDI: init failed", ex);
        }
    }

    static String getVersion(String componentID) {
        String jndiKey = componentID + ".version";
        try {
            log.debug((Object)("retrieving version via JNDI: " + jndiKey));
            InitialContext initContext = new InitialContext();
            String version = (String)initContext.lookup(jndiKey);
            return version;
        }
        catch (Exception ex) {
            throw new IllegalStateException("failed to find version via JNDI: init failed", ex);
        }
    }

    public void doInit() {
        InitialContext initContext;
        try {
            initContext = new InitialContext();
        }
        catch (NamingException ex) {
            throw new IllegalStateException("failed to find JDNI InitialContext", ex);
        }
        String jndiKey = this.componentID + ".cap-template";
        String str = (String)this.initParams.get("input");
        log.debug((Object)("doInit: static capabilities: " + str));
        try {
            URL resURL = super.getResource(str);
            String tmpl = StringUtil.readFromInputStream((InputStream)resURL.openStream(), (String)"UTF-8");
            CapabilitiesReader cr = new CapabilitiesReader();
            cr.read(tmpl);
            try {
                log.debug((Object)"unbinding possible existing template");
                initContext.unbind(jndiKey);
            }
            catch (NamingException e) {
                log.debug((Object)"no previously bound template, continuting");
            }
            initContext.bind(jndiKey, (Object)tmpl);
            log.info((Object)("doInit: capabilities template=" + str + " stored via JNDI: " + jndiKey));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("CONFIG: failed to read capabilities template: " + str, ex);
        }
        try {
            String authRequired = (String)this.initParams.get("authRequired");
            jndiKey = this.componentID + ".authRequired";
            try {
                log.debug((Object)"unbinding possible authRequired value");
                initContext.unbind(jndiKey);
            }
            catch (NamingException e) {
                log.debug((Object)"no previously bound value, continuting");
            }
            if ("true".equals(authRequired)) {
                initContext.bind(jndiKey, (Object)Boolean.TRUE);
                log.info((Object)("doInit: authRequired=true stored via JNDI: " + jndiKey));
            } else {
                initContext.bind(jndiKey, (Object)Boolean.FALSE);
                log.info((Object)("doInit: authRequired=false stored via JNDI: " + jndiKey));
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("CONFIG: failed to set authRequired flag", ex);
        }
        try {
            Version version = CapInitAction.getLibraryVersion(CapInitAction.class);
            jndiKey = this.componentID + ".version";
            try {
                log.debug((Object)"unbinding possible version value");
                initContext.unbind(jndiKey);
            }
            catch (NamingException e) {
                log.debug((Object)"no previously bound value, continuting");
            }
            initContext.bind(jndiKey, (Object)version.getMajorMinor());
            log.info((Object)("doInit: version=" + version + " stored via JNDI: " + jndiKey));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("CONFIG: failed to set version flag", ex);
        }
    }
}

