/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vosi;

import ca.nrc.cadc.auth.AuthenticationUtil;
import ca.nrc.cadc.log.ServletLogInfo;
import ca.nrc.cadc.reg.CapabilitiesReader;
import ca.nrc.cadc.vosi.CapabilitiesParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;

@Deprecated
public class CapabilitiesServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(CapabilitiesServlet.class);
    private static final long serialVersionUID = 201003131300L;
    private String capTemplate;
    protected boolean doTransform = true;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String str = config.getInitParameter("input");
        if (str == null) {
            throw new ExceptionInInitializerError("Missing capabilities input");
        }
        log.info((Object)("static capabilities: " + str));
        try {
            int length;
            URL resURL = config.getServletContext().getResource(str);
            CapabilitiesReader cr = new CapabilitiesReader(true);
            InputStream in = resURL.openStream();
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = in.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            String xml = result.toString("UTF-8");
            cr.read(xml);
            this.capTemplate = xml;
        }
        catch (Throwable t) {
            log.error((Object)("CONFIGURATION ERROR: failed to read capabilities template: " + str), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletLogInfo logInfo = new ServletLogInfo(request);
        long start = System.currentTimeMillis();
        try {
            Subject subject = AuthenticationUtil.getSubject((HttpServletRequest)request);
            logInfo.setSubject(subject);
            log.info((Object)logInfo.start());
            if (this.doTransform) {
                StringReader sr = new StringReader(this.capTemplate);
                CapabilitiesParser cp = new CapabilitiesParser(false);
                Document doc = cp.parse(sr);
                this.transformCapabilities(doc, request);
                this.doOutput(doc, response);
            } else {
                this.doOutput(this.capTemplate, response);
            }
        }
        catch (JDOMException ex) {
            logInfo.setSuccess(false);
            logInfo.setMessage(ex.toString());
            log.error((Object)"BUG: failed to rewrite hostname in accessURL elements", (Throwable)ex);
            response.sendError(500, ex.getMessage());
        }
        finally {
            logInfo.setElapsedTime(Long.valueOf(System.currentTimeMillis() - start));
            log.info((Object)logInfo.end());
        }
    }

    private void transformCapabilities(Document doc, HttpServletRequest request) throws IOException, JDOMException {
        URL rurl = new URL(request.getRequestURL().toString());
        String hostname = rurl.getHost();
        Element root = doc.getRootElement();
        ArrayList<Namespace> nsList = new ArrayList<Namespace>();
        nsList.addAll(root.getAdditionalNamespaces());
        nsList.add(root.getNamespace());
        String xpath = "/vosi:capabilities/capability/interface/accessURL";
        XPathFactory xf = XPathFactory.instance();
        XPathExpression xp = xf.compile(xpath, Filters.element(), null, nsList);
        List accessURLs = xp.evaluate((Object)doc);
        log.debug((Object)("xpath[" + xpath + "] found: " + accessURLs.size()));
        for (Element e : accessURLs) {
            String surl = e.getTextTrim();
            log.debug((Object)("accessURL: " + surl));
            URL url = new URL(surl);
            URL nurl = new URL(url.getProtocol(), hostname, url.getPath());
            log.debug((Object)("accessURL: " + surl + " -> " + nurl));
            e.setText(nurl.toExternalForm());
        }
    }

    private void doOutput(String xml, HttpServletResponse response) throws IOException {
        response.setContentType("text/xml");
        PrintWriter w = response.getWriter();
        w.write(xml);
        w.flush();
    }

    private void doOutput(Document doc, HttpServletResponse response) throws IOException {
        XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
        response.setContentType("text/xml");
        out.output(doc, (OutputStream)response.getOutputStream());
    }
}

