/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vosi.avail;

import ca.nrc.cadc.auth.SSLUtil;
import ca.nrc.cadc.auth.X509CertificateChain;
import ca.nrc.cadc.date.DateUtil;
import ca.nrc.cadc.vosi.avail.CheckException;
import ca.nrc.cadc.vosi.avail.CheckResource;
import java.io.File;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Date;
import java.util.Set;
import java.util.TimeZone;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;

public class CheckCertificate
implements CheckResource {
    private static Logger log = Logger.getLogger(CheckCertificate.class);
    private final File cert;

    public CheckCertificate(File cert) {
        this.cert = cert;
    }

    @Override
    public void check() throws CheckException {
        log.debug((Object)("read - cert: " + this.cert));
        Subject s = null;
        try {
            s = SSLUtil.createSubject((File)this.cert);
        }
        catch (Throwable t) {
            log.debug((Object)("test failed: " + this.cert));
            throw new CheckException("cert check failed (not found): " + t.getMessage());
        }
        log.debug((Object)("check validity - cert: " + this.cert.getAbsolutePath() + " " + this.cert));
        try {
            Set<X509CertificateChain> certs = s.getPublicCredentials(X509CertificateChain.class);
            if (certs.isEmpty()) {
                throw new RuntimeException("failed to load X509 certficate from file(s): " + this.cert.getAbsolutePath());
            }
            X509CertificateChain chain = certs.iterator().next();
            this.checkValidity(chain);
        }
        catch (Throwable t) {
            log.debug((Object)("test failed: " + this.cert));
            throw new CheckException("cert check failed (invalid): " + t.getMessage());
        }
        log.debug((Object)("test succeeded: " + this.cert.getAbsolutePath() + " " + this.cert));
    }

    private void checkValidity(X509CertificateChain chain) {
        DateFormat df = DateUtil.getDateFormat((String)"yyyy-MM-dd HH:mm:ss.SSS", (TimeZone)DateUtil.LOCAL);
        Date start = null;
        Date end = null;
        X500Principal principal = null;
        for (X509Certificate c : chain.getChain()) {
            try {
                start = c.getNotBefore();
                end = c.getNotAfter();
                principal = c.getSubjectX500Principal();
                c.checkValidity();
            }
            catch (CertificateNotYetValidException exp) {
                log.error((Object)(this.cert.getAbsolutePath() + " certificate is not valid yet, DN: " + principal + ", valid from " + df.format(start) + " to " + df.format(end)));
                throw new RuntimeException(this.cert.getAbsolutePath() + "certificate is not valid yet, DN: " + principal + ", valid from " + df.format(start) + " to " + df.format(end));
            }
            catch (CertificateExpiredException exp) {
                log.error((Object)(this.cert.getAbsolutePath() + "certificate has expired, DN: " + principal + ", valid from " + df.format(start) + " to " + df.format(end)));
                throw new RuntimeException(this.cert.getAbsolutePath() + "certificate has expired, DN: " + principal + ", valid from " + df.format(start) + " to " + df.format(end));
            }
        }
    }
}

