/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vosi.avail;

import ca.nrc.cadc.db.DBUtil;
import ca.nrc.cadc.vosi.avail.CheckException;
import ca.nrc.cadc.vosi.avail.CheckResource;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class CheckDataSource
implements CheckResource {
    private static Logger log = Logger.getLogger(CheckDataSource.class);
    private String dataSourceName;
    private DataSource dataSource;
    private String testSQL;
    private boolean expectResults = true;
    private boolean rollback = false;
    private Integer expectNumRows;

    public CheckDataSource(DataSource dataSource, String testSQL) {
        this.dataSource = dataSource;
        this.testSQL = testSQL;
    }

    public CheckDataSource(String dataSourceName, String testSQL) {
        this.dataSourceName = dataSourceName;
        this.testSQL = testSQL;
    }

    public CheckDataSource(String dataSourceName, String testSQL, boolean expectResults) {
        this.dataSourceName = dataSourceName;
        this.testSQL = testSQL;
        this.expectResults = expectResults;
    }

    public CheckDataSource(String dataSourceName, String testSQL, int expectNumRows) {
        this.dataSourceName = dataSourceName;
        this.testSQL = testSQL;
        this.expectNumRows = expectNumRows;
        this.expectResults = true;
    }

    public CheckDataSource(String dataSourceName, String testSQL, boolean expectResults, boolean rollback) {
        this.dataSourceName = dataSourceName;
        this.testSQL = testSQL;
        this.expectResults = expectResults;
        this.rollback = rollback;
    }

    @Override
    public void check() throws CheckException {
        Connection con = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            if (this.dataSource == null && this.dataSourceName != null) {
                this.dataSource = DBUtil.findJNDIDataSource((String)this.dataSourceName);
            }
            con = this.dataSource.getConnection();
            if (this.rollback) {
                con.setAutoCommit(false);
            }
            st = con.createStatement();
            if (this.expectResults) {
                log.debug((Object)"test for results");
                if (this.testSQL.trim().toLowerCase().startsWith("select ")) {
                    rs = st.executeQuery(this.testSQL);
                    if (this.expectNumRows != null) {
                        int numRows = 0;
                        while (rs.next()) {
                            ++numRows;
                        }
                        if (this.expectNumRows != numRows) {
                            String msg = "content fail: " + this.dataSourceName + " (" + this.testSQL + ") expected rows: " + this.expectNumRows + " found: " + numRows;
                            log.warn((Object)msg);
                            throw new CheckException(msg);
                        }
                    } else {
                        rs.next();
                    }
                } else {
                    st.executeUpdate(this.testSQL);
                }
            } else {
                st.execute(this.testSQL);
            }
            log.debug((Object)("test succeeded: " + this.dataSourceName + " (" + this.testSQL + ")"));
        }
        catch (NamingException e) {
            log.warn((Object)("test failed: " + this.dataSourceName + " (" + this.testSQL + ")"));
            throw new CheckException("DataSource not found: " + this.dataSourceName, e);
        }
        catch (SQLException e) {
            log.debug((Object)("test failed: " + this.dataSourceName + " (" + this.testSQL + ")"), (Throwable)e);
            log.warn((Object)("test failed: " + this.dataSourceName + " (" + this.testSQL + ")"));
            throw new CheckException("DataSource is not usable: " + this.dataSourceName, e);
        }
        finally {
            if (this.rollback && con != null) {
                try {
                    con.rollback();
                    con.setAutoCommit(true);
                }
                catch (SQLException e) {
                    log.error((Object)("rollback failed: " + this.dataSourceName + " (" + this.testSQL + ")"), (Throwable)e);
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable ignore) {
                    log.debug((Object)"ResultSet.close failed: ignore", ignore);
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Throwable ignore) {
                    log.debug((Object)"Statement.close failed: ignore", ignore);
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Throwable ignore) {
                    log.debug((Object)"Connection.close failed: ignore", ignore);
                }
            }
        }
    }
}

