/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vosi.avail;

import ca.nrc.cadc.net.HttpDownload;
import ca.nrc.cadc.net.InputStreamWrapper;
import ca.nrc.cadc.vosi.avail.CheckException;
import ca.nrc.cadc.vosi.avail.CheckResource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.log4j.Logger;

public class CheckURL
implements CheckResource {
    private static final Logger log = Logger.getLogger(CheckURL.class);
    private final String name;
    private final URL url;
    private final int expectedResponseCode;
    private final String expectedContentType;

    public CheckURL(String name, URL url, int expectedResponseCode, String expectedContentType) {
        this.name = name;
        this.url = url;
        this.expectedResponseCode = expectedResponseCode;
        this.expectedContentType = expectedContentType;
    }

    public String toString() {
        return "CheckURL[" + this.name + "," + this.url + "]";
    }

    @Override
    public void check() throws CheckException {
        HttpDownload get = null;
        try {
            InputStreamWrapper dump = new InputStreamWrapper(){

                public void read(InputStream in) throws IOException {
                    int num;
                    byte[] buf = new byte[8192];
                    while ((num = in.read(buf)) != -1) {
                        log.debug((Object)("read: " + num));
                    }
                }
            };
            get = new HttpDownload(this.url, dump);
            get.setHeadOnly(true);
            get.setFollowRedirects(true);
            get.run();
        }
        catch (Exception ex) {
            log.debug((Object)"FAIL", (Throwable)ex);
            throw new CheckException(this.name + " " + this.url.toExternalForm() + " test failed: " + ex);
        }
        if (get.getThrowable() != null) {
            log.debug((Object)"FAIL", get.getThrowable());
            throw new CheckException(this.name + " " + this.url.toExternalForm() + " test failed: " + get.getThrowable());
        }
        int responseCode = get.getResponseCode();
        String contentType = get.getContentType();
        int i = contentType.indexOf(59);
        if (i > 0) {
            contentType = contentType.substring(0, i);
        }
        if (responseCode != this.expectedResponseCode || this.expectedContentType != null && !this.expectedContentType.equals(contentType)) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name).append(" ").append(this.url.toExternalForm()).append(" failed:");
            sb.append(" found ").append(contentType).append(" (").append(responseCode).append(")");
            sb.append(" expected ").append(this.expectedContentType).append(" (").append(this.expectedResponseCode).append(")");
            throw new CheckException(sb.toString());
        }
    }
}

