/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vosi.avail;

import ca.nrc.cadc.net.HttpGet;
import ca.nrc.cadc.vosi.Availability;
import ca.nrc.cadc.vosi.avail.CheckException;
import ca.nrc.cadc.vosi.avail.CheckResource;
import ca.nrc.cadc.xml.XmlUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.JDOMException;

public class CheckWebService
implements CheckResource {
    private static Logger log = Logger.getLogger(CheckWebService.class);
    private final URL availabilityURL;
    private final boolean fullCheck;

    @Deprecated
    public CheckWebService(String availabilityURL) throws IllegalArgumentException {
        this.fullCheck = true;
        try {
            this.availabilityURL = new URL(availabilityURL);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("invalid URL: " + availabilityURL, ex);
        }
    }

    public CheckWebService(URL availabilityURL) {
        this(availabilityURL, false);
    }

    public CheckWebService(URL availabilityURL, boolean fullCheck) {
        this.fullCheck = fullCheck;
        if (fullCheck) {
            this.availabilityURL = availabilityURL;
        } else {
            try {
                this.availabilityURL = new URL(availabilityURL.toExternalForm() + "?detail=min");
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException("BUG: failed to append params to " + availabilityURL, ex);
            }
        }
    }

    @Override
    public void check() throws CheckException {
        if (this.fullCheck) {
            log.debug((Object)("fullcheck==true " + this.availabilityURL));
            this.doFullCheck();
        } else {
            log.debug((Object)("fullcheck==false " + this.availabilityURL));
            HttpGet get = new HttpGet(this.availabilityURL, true);
            get.setConnectionTimeout(9000);
            get.setReadTimeout(9000);
            long t = System.currentTimeMillis();
            get.run();
            if (get.getResponseCode() != 200 || get.getThrowable() != null) {
                throw new CheckException("availability check failed: " + this.availabilityURL + " code: " + get.getResponseCode() + " cause: " + get.getThrowable());
            }
            long dt = System.currentTimeMillis() - t;
            log.debug((Object)("fullcheck==false dt=" + dt));
        }
    }

    private void doFullCheck() throws CheckException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            HttpGet get = new HttpGet(this.availabilityURL, (OutputStream)bos);
            get.setConnectionTimeout(20000);
            get.setReadTimeout(60000);
            get.run();
            if (get.getThrowable() != null) {
                throw new CheckException("availability check failed: " + this.availabilityURL + " code: " + get.getResponseCode() + " cause: " + get.getThrowable().getMessage());
            }
            HashMap<String, String> schemaMap = new HashMap<String, String>();
            schemaMap.put("http://www.ivoa.net/xml/VOSIAvailability/v1.0", XmlUtil.getResourceUrlString((String)"VOSIAvailability-v1.0.xsd", CheckWebService.class));
            StringReader reader = new StringReader(bos.toString());
            Document doc = XmlUtil.buildDocument((Reader)reader, schemaMap);
            Availability wsa = Availability.fromXmlDocument(doc);
            if (wsa.isAvailable()) {
                log.debug((Object)("test succeeded: " + this.availabilityURL));
                return;
            }
            throw new CheckException("service " + this.availabilityURL + " is not available, reported reason: " + wsa.note);
        }
        catch (ParseException | JDOMException ex) {
            throw new CheckException("invalid output from " + this.availabilityURL, ex);
        }
        catch (Exception ex) {
            log.error((Object)("unexpected test fail: " + this.availabilityURL), (Throwable)ex);
            throw new CheckException("unexpected test fail: " + this.availabilityURL, ex);
        }
    }
}

