/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.accesscontrol;

import ca.nrc.cadc.auth.AuthMethod;
import ca.nrc.cadc.auth.AuthenticationUtil;
import ca.nrc.cadc.auth.HttpPrincipal;
import ca.nrc.cadc.net.HttpPost;
import ca.nrc.cadc.net.ResourceNotFoundException;
import ca.nrc.cadc.reg.Standards;
import ca.nrc.cadc.reg.client.RegistryClient;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.security.AccessControlException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;

public class AccessControlClient {
    private static final String CADC_TOKEN_HEADER_KEY = "X-CADC-DelegationToken";
    private static final String CADC_PASSWORD_FIELD = "password";
    private final RegistryClient registryClient;
    private final URI groupManagementServiceURI;
    private static final Logger log = Logger.getLogger(AccessControlClient.class);

    public AccessControlClient(URI serviceURI) throws IllegalArgumentException {
        this(serviceURI, new RegistryClient());
    }

    AccessControlClient(URI serviceURI, RegistryClient registryClient) {
        this.registryClient = registryClient;
        this.groupManagementServiceURI = serviceURI;
    }

    private URL lookupLoginURL() {
        return this.registryClient.getServiceURL(this.groupManagementServiceURI, Standards.UMS_LOGIN_01, AuthMethod.ANON);
    }

    public String login(String username, char[] password) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("username", username);
        payload.put(CADC_PASSWORD_FIELD, new String(password));
        int statusCode = this.post(this.lookupLoginURL(), payload, out);
        switch (statusCode) {
            case 200: {
                return out.toString();
            }
            case 400: {
                throw new IllegalArgumentException(out.toString());
            }
            case 401: {
                throw new AccessControlException("Login denied");
            }
        }
        throw new IllegalArgumentException(String.format("Unable to login '%s'.\nServer error code: %d.", username, statusCode));
    }

    private URL lookupPasswordResetURL() {
        return this.registryClient.getServiceURL(this.groupManagementServiceURI, Standards.UMS_RESETPASS_01, AuthMethod.TOKEN);
    }

    public void resetPassword(char[] newPassword, char[] token) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        final HashMap<String, String> payload = new HashMap<String, String>();
        payload.put(CADC_PASSWORD_FIELD, new String(newPassword));
        final HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(CADC_TOKEN_HEADER_KEY, new String(token));
        Subject subject = AuthenticationUtil.getAnonSubject();
        try {
            Subject.doAs(subject, new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    HttpPost thePost = AccessControlClient.this.postNoRedirect(AccessControlClient.this.lookupPasswordResetURL(), payload, headers);
                    int statusCode = thePost.getResponseCode();
                    StringBuilder logStr = new StringBuilder();
                    logStr.append("Unable to reset password");
                    StringBuilder throwStr = new StringBuilder();
                    throwStr.append("Unable to reset password");
                    StringBuilder reasonPart = new StringBuilder();
                    if (statusCode != 200) {
                        reasonPart.append(" - ");
                        reasonPart.append(thePost.getResponseCode());
                        reasonPart.append(": ");
                        reasonPart.append(thePost.getThrowable().toString());
                    }
                    String msg = "";
                    switch (statusCode) {
                        case 200: {
                            break;
                        }
                        case 400: {
                            throwStr.append(": ");
                            throwStr.append(thePost.getThrowable().getMessage());
                            logStr.append(msg);
                            logStr.append(reasonPart.toString());
                            log.error((Object)logStr.toString());
                            throw new IllegalArgumentException(throwStr.toString());
                        }
                        case 401: 
                        case 403: {
                            msg = ": Login denied";
                            throwStr.append(msg);
                            logStr.append(msg);
                            logStr.append(reasonPart.toString());
                            log.error((Object)logStr.toString());
                            throw new AccessControlException(throwStr.toString());
                        }
                        case 404: {
                            msg = ": Service unavailable";
                            throwStr.append(msg);
                            logStr.append(msg);
                            logStr.append(reasonPart.toString());
                            log.error((Object)logStr.toString());
                            throw new ResourceNotFoundException(throwStr.toString());
                        }
                        case -1: {
                            throwStr.append(": Bad request");
                            logStr.append(": Call not completed");
                            logStr.append(reasonPart.toString());
                            log.error((Object)logStr.toString());
                            throw new IllegalStateException(throwStr.toString());
                        }
                        case 500: {
                            msg = ": Server error";
                            throwStr.append(msg);
                            logStr.append(msg);
                            logStr.append(reasonPart.toString());
                            log.error((Object)logStr.toString());
                            throw new IllegalStateException(throwStr.toString());
                        }
                        default: {
                            msg = ": Unknown error";
                            throwStr.append(msg);
                            logStr.append(msg);
                            logStr.append(reasonPart.toString());
                            log.error((Object)logStr.toString());
                            throw new IllegalStateException(throwStr.toString());
                        }
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pea) {
            Exception cause = pea.getException();
            if (cause == null) {
                log.error((Object)"Bug: Unknown error.", (Throwable)cause);
            }
            if (cause instanceof AccessControlException) {
                throw (AccessControlException)cause;
            }
            if (cause instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    int post(URL url, Map<String, Object> payload, OutputStream out) {
        Map<String, String> headers = Collections.emptyMap();
        return this.post(url, payload, headers, out);
    }

    int post(URL url, Map<String, Object> payload, Map<String, String> headers, OutputStream out) {
        HttpPost post = new HttpPost(url, payload, out);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            post.setRequestProperty(entry.getKey(), entry.getValue());
        }
        post.run();
        return post.getResponseCode();
    }

    HttpPost postNoRedirect(URL url, Map<String, Object> payload, Map<String, String> headers) {
        HttpPost post = new HttpPost(url, payload, false);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            post.setRequestProperty(entry.getKey(), entry.getValue());
        }
        post.run();
        return post;
    }

    public String getCurrentHttpPrincipalUsername(Subject subject) {
        String username;
        AuthMethod authMethod = AuthenticationUtil.getAuthMethod((Subject)subject);
        if (authMethod != null && authMethod != AuthMethod.ANON) {
            Set<HttpPrincipal> curPrincipals = subject.getPrincipals(HttpPrincipal.class);
            HttpPrincipal[] principalArray = new HttpPrincipal[curPrincipals.size()];
            username = curPrincipals.toArray(principalArray)[0].getName();
        } else {
            username = null;
        }
        return username;
    }
}

