/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.accesscontrol;

import ca.nrc.cadc.config.ApplicationConfiguration;
import ca.nrc.cadc.util.StringUtil;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class AccessControlUtil {
    private static final Logger LOG = Logger.getLogger(AccessControlUtil.class);
    public static final String SSO_COOKIE_NAME = "CADC_SSO";
    static final String SSO_SERVERS_KEY = "SSO_SERVERS";
    static final String COOKIE_DOMAINS_KEY = "COOKIE_DOMAINS";
    public static final String SSO_COOKIE_LIFETIME_SECONDS_KEY = "SSO_TOKEN_LIFETIME_SECONDS";
    public static final String DEFAULT_AC_PROPERTIES_FILE_PATH = System.getProperty("user.home") + "/config/AccessControl.properties";
    public static final int DEFAULT_COOKIE_LIFETIME_SECONDS = 172800;
    private final ApplicationConfiguration applicationConfiguration;

    public AccessControlUtil(ApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
    }

    public AccessControlUtil(String filePath) {
        this(new ApplicationConfiguration(filePath));
    }

    public AccessControlUtil() {
        this(DEFAULT_AC_PROPERTIES_FILE_PATH);
    }

    private Set<String> addServers(String hostsString) {
        HashSet<String> servers = new HashSet<String>();
        if (StringUtil.hasText((String)hostsString)) {
            String[] hosts;
            for (String host : hosts = hostsString.split(" ")) {
                if (!StringUtil.hasLength((String)host)) continue;
                servers.add(host);
            }
        }
        return servers;
    }

    public Set<String> getCookieDomains() {
        String hostsString = (String)this.applicationConfiguration.lookup(COOKIE_DOMAINS_KEY);
        return this.addServers(hostsString);
    }

    public Set<String> getSSOServers() {
        String hostsString = (String)this.applicationConfiguration.lookup(SSO_SERVERS_KEY);
        return this.addServers(hostsString);
    }

    public int getCookieLifetimeSeconds() {
        return this.applicationConfiguration.lookupInt(SSO_COOKIE_LIFETIME_SECONDS_KEY, 172800);
    }
}

