/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.config;

import ca.nrc.cadc.util.StringUtil;
import java.net.URI;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.SystemConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.MergeCombiner;
import org.apache.commons.configuration2.tree.NodeCombiner;
import org.apache.log4j.Logger;

public class ApplicationConfiguration {
    private static final Logger LOGGER = Logger.getLogger(ApplicationConfiguration.class);
    private final Configuration configuration;

    public ApplicationConfiguration(String filePath) {
        CombinedConfiguration combinedConfiguration = new CombinedConfiguration((NodeCombiner)new MergeCombiner());
        combinedConfiguration.addConfiguration((Configuration)new SystemConfiguration());
        Parameters parameters = new Parameters();
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)parameters.properties().setFileName(filePath)});
        try {
            combinedConfiguration.addConfiguration((Configuration)builder.getConfiguration());
        }
        catch (ConfigurationException var5) {
            LOGGER.warn((Object)String.format("No configuration found at %s.\nUsing defaults.", filePath));
        }
        this.configuration = combinedConfiguration;
    }

    public ApplicationConfiguration() {
        this.configuration = new SystemConfiguration();
    }

    public URI lookupServiceURI(String key, URI defaultValue) {
        String value = (String)this.lookup(key);
        return StringUtil.hasText((String)value) ? URI.create(value) : defaultValue;
    }

    public int lookupInt(String key, int defaultValue) {
        return this.configuration.getInt(key, defaultValue);
    }

    public boolean lookupBoolean(String key, boolean defaultValue) {
        return this.configuration.getBoolean(key, defaultValue);
    }

    public String lookup(String key, String defaultValue) {
        return this.configuration.getString(key, defaultValue);
    }

    public String[] lookupAll(String key) {
        return this.configuration.getStringArray(key);
    }

    public <T> T lookup(String key) {
        return (T)this.configuration.getProperty(key);
    }
}

