/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.web;

import ca.nrc.cadc.accesscontrol.AccessControlUtil;
import ca.nrc.cadc.auth.AuthMethod;
import ca.nrc.cadc.auth.AuthenticationUtil;
import ca.nrc.cadc.auth.PrincipalExtractor;
import ca.nrc.cadc.auth.SSOCookieCredential;
import ca.nrc.cadc.net.NetUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;

public class SubjectGenerator {
    private final AccessControlUtil accessControlUtil;

    public SubjectGenerator(AccessControlUtil accessControlUtil) {
        this.accessControlUtil = accessControlUtil;
    }

    public SubjectGenerator() {
        this(new AccessControlUtil());
    }

    public final Subject generate(PrincipalExtractor principalExtractor) throws IOException {
        SSOCookieCredential cookieCredential;
        Subject subject = AuthenticationUtil.getSubject((PrincipalExtractor)principalExtractor);
        Set<SSOCookieCredential> cookieCredentials = subject.getPublicCredentials(SSOCookieCredential.class);
        SSOCookieCredential sSOCookieCredential = cookieCredential = cookieCredentials.isEmpty() ? null : cookieCredentials.toArray(new SSOCookieCredential[0])[0];
        if (cookieCredential != null) {
            HashSet<Object> publicCred = new HashSet<Object>();
            for (String serverName : this.accessControlUtil.getSSOServers()) {
                publicCred.add(new SSOCookieCredential(cookieCredential.getSsoCookieValue(), NetUtil.getDomainName((String)serverName)));
                publicCred.add(AuthMethod.COOKIE);
            }
            subject.getPublicCredentials().addAll(publicCred);
        }
        return subject;
    }
}

