/*
 * Decompiled with CFR 0.152.
 */
package org.opencadc.proxy;

import ca.nrc.cadc.auth.NotAuthenticatedException;
import ca.nrc.cadc.io.ByteLimitExceededException;
import ca.nrc.cadc.net.ExpectationFailedException;
import ca.nrc.cadc.net.HttpDownload;
import ca.nrc.cadc.net.HttpTransfer;
import ca.nrc.cadc.net.PreconditionFailedException;
import ca.nrc.cadc.net.ResourceAlreadyExistsException;
import ca.nrc.cadc.net.ResourceNotFoundException;
import ca.nrc.cadc.net.TransientException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.security.AccessControlException;
import javax.servlet.http.HttpServletResponse;

public class HttpProxy
extends HttpTransfer {
    private final HttpServletResponse response;

    public HttpProxy(URL url, HttpServletResponse response) {
        super(url, true);
        this.response = response;
    }

    public void prepare() throws AccessControlException, NotAuthenticatedException, ByteLimitExceededException, ExpectationFailedException, IllegalArgumentException, PreconditionFailedException, ResourceAlreadyExistsException, ResourceNotFoundException, TransientException, IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    public void run() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        HttpDownload download = new HttpDownload(this.remoteURL, (OutputStream)outputStream);
        download.setFollowRedirects(this.followRedirects);
        download.setRequestProperties(super.getRequestProperties());
        download.run();
        long contentLength = download.getContentLength();
        this.failure = download.getThrowable();
        try {
            this.response.setStatus(download.getResponseCode());
            this.response.setContentType(download.getContentType());
            if (contentLength > 0L) {
                this.response.setContentLength(Long.valueOf(contentLength).intValue());
            }
            this.response.getOutputStream().write(outputStream.toByteArray());
        }
        catch (IOException e) {
            this.failure = e;
        }
    }
}

