/*
 * Decompiled with CFR 0.152.
 */
package org.opencadc.proxy;

import ca.nrc.cadc.auth.AuthMethod;
import ca.nrc.cadc.net.FileContent;
import ca.nrc.cadc.net.HttpPost;
import ca.nrc.cadc.net.HttpUpload;
import ca.nrc.cadc.reg.client.RegistryClient;
import ca.nrc.cadc.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencadc.proxy.HttpProxy;
import org.opencadc.proxy.RequestParameterName;
import org.opencadc.proxy.ServiceParameterMap;
import org.opencadc.proxy.ServiceParameterName;

public class ProxyServlet
extends HttpServlet {
    private static final String REQUEST_HEADER_PREFIX = "X-CADC-Proxy_";

    RegistryClient getRegistryClient() {
        return new RegistryClient();
    }

    private Map<String, String[]> buildRequestParameterMap(Map<String, String[]> requestParameters) {
        HashMap<String, String[]> requestParameterMap = new HashMap<String, String[]>();
        for (RequestParameterName requestParameterName : RequestParameterName.values()) {
            String[] values = requestParameters.get(requestParameterName.name());
            if (values == null) continue;
            requestParameterMap.put(requestParameterName.name(), values);
        }
        return requestParameterMap;
    }

    private ServiceParameterMap buildServiceParameterMap(Map<String, String[]> requestParameters) {
        ServiceParameterMap serviceParameterMap = new ServiceParameterMap();
        for (ServiceParameterName serviceParameterName : ServiceParameterName.values()) {
            serviceParameterMap.putFirst(serviceParameterName, requestParameters.get(serviceParameterName.name()));
        }
        return serviceParameterMap;
    }

    private ServiceParameterMap buildServiceParameterMap(HttpServletRequest request) {
        ServiceParameterMap serviceParameterMap = new ServiceParameterMap();
        for (ServiceParameterName serviceParameterName : ServiceParameterName.values()) {
            serviceParameterMap.put(serviceParameterName, request.getHeader(REQUEST_HEADER_PREFIX + serviceParameterName.name()));
        }
        return serviceParameterMap;
    }

    URL lookupServiceURL(ServiceParameterMap serviceParameters) throws IOException {
        URL serviceURLWithQuery;
        URL serviceURLWithPath;
        RegistryClient registryClient = this.getRegistryClient();
        URL serviceURL = registryClient.getServiceURL(serviceParameters.getURI(ServiceParameterName.RESOURCE_ID), serviceParameters.getURI(ServiceParameterName.STANDARD_ID), AuthMethod.valueOf((String)((String)serviceParameters.get((Object)ServiceParameterName.AUTH_TYPE)).toUpperCase()), serviceParameters.getURI(ServiceParameterName.INTERFACE_TYPE_ID));
        if (serviceURL == null) {
            throw new IllegalArgumentException("No Service URL matching provided parameters:\n\n" + serviceParameters.toString() + "\n\n");
        }
        if (serviceParameters.containsKey((Object)ServiceParameterName.EXTRA_PATH)) {
            String extraPath = (String)serviceParameters.get((Object)ServiceParameterName.EXTRA_PATH);
            serviceURLWithPath = new URL(serviceURL, serviceURL.getPath() + "/" + extraPath);
        } else {
            serviceURLWithPath = serviceURL;
        }
        if (serviceParameters.containsKey((Object)ServiceParameterName.EXTRA_QUERY)) {
            String extraQuery = (String)serviceParameters.get((Object)ServiceParameterName.EXTRA_QUERY);
            serviceURLWithQuery = new URL(serviceURLWithPath, serviceURLWithPath.getPath() + (extraQuery.startsWith("?") ? extraQuery : "?" + extraQuery));
        } else {
            serviceURLWithQuery = serviceURLWithPath;
        }
        return serviceURLWithQuery;
    }

    URL lookupServiceURL(Map<String, String[]> parameters) throws IOException {
        ServiceParameterMap serviceParameters = this.buildServiceParameterMap(parameters);
        return this.lookupServiceURL(serviceParameters);
    }

    URL lookupServiceURL(HttpServletRequest request) throws IOException {
        ServiceParameterMap serviceParameters = this.buildServiceParameterMap(request);
        return this.lookupServiceURL(serviceParameters);
    }

    HttpPost getHttpPost(URL url, Map<String, String[]> payload) {
        HashMap<String, List<Object>> postPayload = new HashMap<String, List<Object>>();
        for (Map.Entry<String, String[]> entry : payload.entrySet()) {
            postPayload.put(entry.getKey(), Arrays.asList((Object[])entry.getValue()));
        }
        return new HttpPost(url, postPayload, false);
    }

    HttpPost getHttpPost(URL url, byte[] data, String contentType) {
        return new HttpPost(url, new FileContent(data, contentType), false);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        HttpPost post;
        URL serviceURL = this.lookupServiceURL(req.getParameterMap());
        Map<String, String[]> parameterMap = this.buildRequestParameterMap(req.getParameterMap());
        if (parameterMap.containsKey(RequestParameterName.DATA.name())) {
            byte[] data = parameterMap.get(RequestParameterName.DATA.name())[0].getBytes();
            String contentType = parameterMap.containsKey(RequestParameterName.DATA_CONTENT_TYPE.name()) ? parameterMap.get(RequestParameterName.DATA_CONTENT_TYPE.name())[0] : "application/json";
            post = this.getHttpPost(serviceURL, data, contentType);
        } else {
            post = this.getHttpPost(serviceURL, req.getParameterMap());
        }
        post.setRequestProperty("Accept", req.getHeader("Accept"));
        post.run();
        URL redirectURL = post.getRedirectURL();
        if (redirectURL == null) {
            resp.setContentType(post.getContentType());
            resp.setStatus(post.getResponseCode());
        } else {
            HttpProxy proxyRedirect = this.getHttpProxy(redirectURL, resp);
            proxyRedirect.run();
        }
    }

    HttpUpload getHttpUpload(URL url, InputStream inputStream) {
        return new HttpUpload(inputStream, url);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        URL serviceURL = this.lookupServiceURL(req);
        HttpUpload put = this.getHttpUpload(serviceURL, (InputStream)req.getInputStream());
        put.setRequestProperty("Accept", req.getHeader("Accept"));
        put.setRequestProperty("Content-Type", req.getContentType());
        put.run();
        resp.setStatus(put.getResponseCode());
    }

    HttpProxy getHttpProxy(URL url, HttpServletResponse response) {
        return new HttpProxy(url, response);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String acceptContentType;
        URL serviceURL = this.lookupServiceURL(req.getParameterMap());
        HttpProxy proxy = this.getHttpProxy(serviceURL, resp);
        String contentType = req.getContentType();
        if (StringUtil.hasText((String)contentType)) {
            proxy.setRequestProperty("Content-Type", contentType);
        }
        if (StringUtil.hasText((String)(acceptContentType = req.getHeader("Accept")))) {
            proxy.setRequestProperty("Accept", acceptContentType);
        }
        proxy.run();
    }
}

