/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.astro;

import ca.nrc.cadc.astro.UnitConverter;
import ca.nrc.cadc.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;

public class EnergyUnitConverter
implements UnitConverter {
    private static final String[] ALL_UNITS;
    private static final String[] FREQ_UNITS;
    private static final double[] FREQ_MULT;
    private static final String[] EN_UNITS;
    private static final double[] EN_MULT;
    private static final String[] WAVE_UNITS;
    private static final double[] WAVE_MULT;
    private static final double c = 2.997925E8;
    private static final double h = 6.6262E-27;
    private static final double eV = 1.602192E-12;

    @Override
    public String[] getSupportedUnits() {
        return ALL_UNITS;
    }

    @Override
    public double convert(double value, String units) {
        return this.toMeters(value, units);
    }

    public double toMeters(double d, String units) {
        int i = ArrayUtil.matches((String)("^" + units + "$"), (String[])FREQ_UNITS, (boolean)true);
        if (i != -1) {
            return this.freqToMeters(d, i);
        }
        i = ArrayUtil.matches((String)("^" + units + "$"), (String[])EN_UNITS, (boolean)true);
        if (i != -1) {
            return this.energyToMeters(d, i);
        }
        i = ArrayUtil.matches((String)("^" + units + "$"), (String[])WAVE_UNITS, (boolean)true);
        if (i != -1) {
            return this.wavelengthToMeters(d, i);
        }
        throw new IllegalArgumentException("Unknown units: " + units);
    }

    public double toHz(double d, String units) {
        int i = ArrayUtil.matches((String)("^" + units + "$"), (String[])FREQ_UNITS, (boolean)true);
        if (i != -1) {
            return this.freqToHz(d, i);
        }
        i = ArrayUtil.matches((String)("^" + units + "$"), (String[])EN_UNITS, (boolean)true);
        if (i != -1) {
            return this.energyToHz(d, i);
        }
        i = ArrayUtil.matches((String)("^" + units + "$"), (String[])WAVE_UNITS, (boolean)true);
        if (i != -1) {
            return this.wavelengthToHz(d, i);
        }
        throw new IllegalArgumentException("unknown units: " + units);
    }

    public double toDeltaMeters(double d1, double d2, String units) {
        double w1 = this.toMeters(d1, units);
        double w2 = this.toMeters(d2, units);
        return Math.abs(w2 - w1);
    }

    public double toDeltaHz(double d1, double d2, String units) {
        double f1 = this.toHz(d1, units);
        double f2 = this.toHz(d2, units);
        return Math.abs(f2 - f1);
    }

    private double freqToMeters(double d, int i) {
        double nu = d * FREQ_MULT[i];
        return 2.997925E8 / nu;
    }

    private double energyToMeters(double d, int i) {
        double e = 1.602192E-12 * d * EN_MULT[i];
        return 1.9864850635E-18 / e;
    }

    private double wavelengthToMeters(double d, int i) {
        return d * WAVE_MULT[i];
    }

    private double freqToHz(double d, int i) {
        return d * FREQ_MULT[i];
    }

    private double energyToHz(double d, int i) {
        double w = this.energyToMeters(d, i);
        return 2.997925E8 / w;
    }

    private double wavelengthToHz(double d, int i) {
        double w = d * WAVE_MULT[i];
        return 2.997925E8 / w;
    }

    public static void main(String[] args) {
        EnergyUnitConverter euc = new EnergyUnitConverter();
        for (String u : WAVE_UNITS) {
            System.out.println("absolute: 5" + u + " = " + euc.toMeters(5.0, u) + "m == " + euc.toHz(5.0, u) + "Hz");
            System.out.println("relative: 4-6" + u + " = " + euc.toDeltaMeters(4.0, 6.0, u) + "m == " + euc.toDeltaHz(4.0, 6.0, u) + "Hz");
        }
        System.out.println("========");
        for (String u : FREQ_UNITS) {
            System.out.println("absolute: 5" + u + " = " + euc.toMeters(5.0, u) + "m == " + euc.toHz(5.0, u) + "Hz");
            System.out.println("relative: 4-6" + u + " = " + euc.toDeltaMeters(4.0, 6.0, u) + "m == " + euc.toDeltaHz(4.0, 6.0, u) + "Hz");
        }
        System.out.println("========");
        for (String u : EN_UNITS) {
            System.out.println("absolute: 5" + u + " = " + euc.toMeters(5.0, u) + "m == " + euc.toHz(5.0, u) + "Hz");
            System.out.println("relative: 4-6" + u + " = " + euc.toDeltaMeters(4.0, 6.0, u) + "m == " + euc.toDeltaHz(4.0, 6.0, u) + "Hz");
        }
    }

    static {
        FREQ_UNITS = new String[]{"Hz", "kHz", "MHz", "GHz"};
        FREQ_MULT = new double[]{1.0, 1000.0, 1000000.0, 1.0E9};
        EN_UNITS = new String[]{"eV", "keV", "MeV", "GeV"};
        EN_MULT = new double[]{1.0, 1000.0, 1000000.0, 1.0E9};
        WAVE_UNITS = new String[]{"m", "cm", "mm", "um", "\u00b5m", "nm", "A"};
        WAVE_MULT = new double[]{1.0, 0.01, 0.001, 1.0E-6, 1.0E-6, 1.0E-9, 1.0E-10};
        ArrayList<String> allUnitList = new ArrayList<String>(Arrays.asList(FREQ_UNITS));
        allUnitList.addAll(Arrays.asList(EN_UNITS));
        allUnitList.addAll(Arrays.asList(WAVE_UNITS));
        ALL_UNITS = allUnitList.toArray(new String[allUnitList.size()]);
    }
}

