/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.search.nameresolver;

import ca.nrc.cadc.auth.AuthMethod;
import ca.nrc.cadc.net.HttpDownload;
import ca.nrc.cadc.net.InputStreamWrapper;
import ca.nrc.cadc.reg.Standards;
import ca.nrc.cadc.reg.client.RegistryClient;
import ca.nrc.cadc.search.nameresolver.NameResolverData;
import ca.nrc.cadc.search.nameresolver.exception.ClientException;
import ca.nrc.cadc.search.nameresolver.exception.TargetNotFoundException;
import ca.nrc.cadc.search.nameresolver.exception.WebServiceException;
import ca.nrc.cadc.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Properties;

public class NameResolver {
    private static final int NAME_RESOLVER_HTTP_ERROR_CODE = 425;
    private static final String SERVICE_PARAMETER = "&service=";
    private static final String CACHED_PARAMETER = "&cached=";
    private static final String MAX_DETAIL_PARAMETER = "&detail=max";
    private static final String[] SERVICES = new String[]{"NED", "SIMBAD", "VIZIER", "ALL"};

    public NameResolverData resolve(String target) throws ClientException, WebServiceException, TargetNotFoundException {
        return this.resolve(target, null, true, false);
    }

    public NameResolverData resolve(String target, boolean cached) throws ClientException, WebServiceException, TargetNotFoundException {
        return this.resolve(target, null, cached, false);
    }

    public NameResolverData resolve(String target, String service) throws ClientException, WebServiceException, TargetNotFoundException {
        return this.resolve(target, service, true, false);
    }

    public NameResolverData resolve(String target, String service, boolean cached, boolean maxDetail) throws ClientException, WebServiceException, TargetNotFoundException {
        if (target == null || target.length() == 0) {
            throw new ClientException("Target not specified");
        }
        this.validateService(service);
        try {
            URL url = new URL(this.getUrlString(URLEncoder.encode(target, "UTF-8"), service, cached, maxDetail));
            final Properties properties = new Properties();
            HttpDownload httpDownload = new HttpDownload(url, new InputStreamWrapper(){

                public void read(InputStream inputStream) throws IOException {
                    properties.load(inputStream);
                }
            });
            httpDownload.run();
            int responseCode = httpDownload.getResponseCode();
            if (responseCode == 425) {
                throw new TargetNotFoundException("Unable to resolve target " + target);
            }
            if (responseCode != 200) {
                throw new WebServiceException("Name Resolver Web Service error, HTTP response code " + responseCode);
            }
            return new NameResolverData(properties);
        }
        catch (UnsupportedEncodingException uee) {
            throw new ClientException("Unsupported url encoding: " + uee.getMessage());
        }
        catch (MalformedURLException mue) {
            throw new ClientException("Malformed url: " + mue.getMessage());
        }
        catch (NumberFormatException nfe) {
            throw new ClientException("Number format exception: " + nfe.getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw new ClientException("Illegal argument exception: " + iae.getMessage());
        }
    }

    private void validateService(String service) throws ClientException {
        if (StringUtil.hasText((String)service)) {
            String[] services;
            if (service.matches("[a-zA-Z,]*\\s+.*")) {
                throw new ClientException("Invalid whitespace character in service argument");
            }
            for (String name : services = service.split(",")) {
                boolean found = false;
                for (String serviceName : SERVICES) {
                    if (!name.equalsIgnoreCase(serviceName)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new ClientException("Invalid service argument " + name);
            }
        }
    }

    private String getUrlString(String encodedTarget, String service, boolean cached, boolean maxDetail) {
        RegistryClient registryClient = new RegistryClient();
        URL resolverURL = registryClient.getServiceURL(URI.create("ivo://cadc.nrc.ca/resolver"), Standards.RESOLVER_10, AuthMethod.ANON);
        StringBuilder sb = new StringBuilder();
        sb.append(resolverURL.toString());
        sb.append("?format=ascii&target=");
        sb.append(encodedTarget);
        if (service != null) {
            sb.append(SERVICE_PARAMETER).append(service.toLowerCase());
        }
        if (!cached) {
            sb.append(CACHED_PARAMETER).append("no");
        }
        if (maxDetail) {
            sb.append(MAX_DETAIL_PARAMETER);
        }
        return sb.toString();
    }
}

