/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.search.nameresolver;

import ca.nrc.cadc.astro.CoordUtil;
import ca.nrc.cadc.search.nameresolver.NameResolverDataKey;
import ca.nrc.cadc.search.nameresolver.exception.ClientException;
import java.util.Properties;

public class NameResolverData {
    private static final String LF = "\n";
    private double ra;
    private double dec;
    private String target;
    private String coordsys;
    private String service;
    private String objectName;
    private String objectType;
    private String morphologyType;
    private int time;

    public NameResolverData(Properties properties) throws ClientException {
        this.ra = CoordUtil.raToDegrees(this.getProperty(properties, NameResolverDataKey.RA));
        this.dec = CoordUtil.decToDegrees(this.getProperty(properties, NameResolverDataKey.DEC));
        this.service = this.getProperty(properties, NameResolverDataKey.SERVICE);
        this.coordsys = this.getProperty(properties, NameResolverDataKey.COORDSYS);
        this.time = Integer.parseInt(this.getProperty(properties, NameResolverDataKey.TIME));
        this.target = this.getProperty(properties, NameResolverDataKey.TARGET);
        this.objectName = this.getProperty(properties, NameResolverDataKey.ONAME);
        this.objectType = this.getProperty(properties, NameResolverDataKey.OTYPE);
        this.morphologyType = this.getProperty(properties, NameResolverDataKey.MTYPE);
    }

    private String getProperty(Properties properties, NameResolverDataKey nameResolverDataKey) throws ClientException {
        if (properties.containsKey(nameResolverDataKey.getKeyLabel())) {
            return properties.getProperty(nameResolverDataKey.getKeyLabel());
        }
        if (nameResolverDataKey.isRequired()) {
            throw new ClientException(nameResolverDataKey.getKeyLabel() + " not found in query results.");
        }
        return null;
    }

    public NameResolverData(double ra, double dec, String target, String coordsys, String service, String objectName, String objectType, String morphologyType, int time) {
        this.ra = ra;
        this.dec = dec;
        this.target = target;
        this.coordsys = coordsys;
        this.service = service;
        this.objectName = objectName;
        this.objectType = objectType;
        this.morphologyType = morphologyType;
        this.time = time;
    }

    public double getRa() {
        return this.ra;
    }

    public double getDec() {
        return this.dec;
    }

    public String getTarget() {
        return this.target;
    }

    public String getCoordsys() {
        return this.coordsys;
    }

    public String getService() {
        return this.service;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getMorphologyType() {
        return this.morphologyType;
    }

    public int getTime() {
        return this.time;
    }

    public String toString() {
        return "target=" + this.target + LF + "service=" + this.service + LF + "coordsys=" + this.coordsys + LF + "ra=" + this.ra + LF + "dec=" + this.dec + LF + "oname=" + (this.objectName == null ? "" : this.objectName) + LF + "otype=" + (this.objectType == null ? "" : this.objectType) + LF + "mtype=" + (this.morphologyType == null ? "" : this.morphologyType) + LF + "time=" + this.time + LF;
    }
}

