/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.search.parser;

import ca.nrc.cadc.search.parser.Numeric;
import ca.nrc.cadc.search.parser.exception.NumericParserException;
import ca.nrc.cadc.util.StringUtil;

public abstract class AbstractNumericParser {
    public static String QUERY_SEPARATER_REGEX = "[\\s,]+";
    private String source;
    private Numeric result;
    private boolean parseUnit = true;

    public AbstractNumericParser(String val) throws NumericParserException {
        this.setSource(val);
        this.parse();
    }

    public AbstractNumericParser() {
    }

    public abstract void parse() throws NumericParserException;

    protected Double parseDouble() throws NumberFormatException {
        Double returnValue;
        String s = this.getSource();
        try {
            returnValue = Double.parseDouble(s);
            this.parseUnit = false;
        }
        catch (NumberFormatException ignore) {
            if (this.isDoubleCharacter(s.charAt(0))) {
                char c;
                StringBuilder numberStringBuilder = new StringBuilder(8);
                char[] charArray = s.toCharArray();
                int index = 0;
                while (index < charArray.length && this.isDoubleCharacter(c = charArray[index++])) {
                    numberStringBuilder.append(c);
                }
                returnValue = Double.parseDouble(numberStringBuilder.toString());
            }
            returnValue = null;
        }
        return returnValue;
    }

    protected String parseUnit() {
        String s = this.getSource();
        if (this.parseUnit && StringUtil.hasLength((String)s)) {
            StringBuilder unitStringBuilder = new StringBuilder(8);
            for (char c : s.toCharArray()) {
                if (this.isDoubleCharacter(c) || Character.isSpaceChar(c)) continue;
                unitStringBuilder.append(c);
            }
            return unitStringBuilder.toString();
        }
        return null;
    }

    private boolean isDoubleCharacter(char c) {
        return Character.isDigit(c) || c == '.';
    }

    protected void setResult(Numeric res) {
        this.result = res;
    }

    public Numeric getResult() {
        return this.result;
    }

    public Number getValue() {
        return this.getResult().value;
    }

    public Number getTolerance() {
        return this.getResult().tolerance;
    }

    public String getUnit() {
        return this.getResult().unit;
    }

    public void setSource(String val) {
        this.source = val;
    }

    protected String getSource() {
        return this.source;
    }
}

