/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.search.parser;

import ca.nrc.cadc.search.parser.CoordSys;
import ca.nrc.cadc.search.parser.RadiusParser;
import ca.nrc.cadc.search.parser.Range;
import ca.nrc.cadc.search.parser.RangeParser;
import ca.nrc.cadc.search.parser.TargetData;
import ca.nrc.cadc.search.parser.exception.NumericParserException;
import ca.nrc.cadc.search.parser.exception.PositionParserException;
import ca.nrc.cadc.search.parser.exception.RangeParserException;
import ca.nrc.cadc.util.CaseInsensitiveStringComparator;
import ca.nrc.cadc.util.StringUtil;
import java.awt.geom.Point2D;
import jsky.coords.wcscon;
import org.apache.log4j.Logger;

public abstract class AbstractPositionParser {
    private static final Logger log = Logger.getLogger(AbstractPositionParser.class);
    public static final double DEFAULT_RADIUS = 0.0166667;

    public TargetData parse(String target) throws PositionParserException {
        if (!StringUtil.hasText((String)target)) {
            throw new PositionParserException("Null or empty target");
        }
        TargetData targetData = new TargetData();
        targetData.setTarget(target);
        targetData.setRadius(0.0166667);
        this.parseCoordinates(target, targetData);
        return targetData;
    }

    protected String sanitizeTarget(String target) {
        return target.replace(",", " ").replaceAll("(\\s*)(\\.{2,})(\\s*)", "$2");
    }

    String[] partition(String target) {
        String sanitizedTarget = this.sanitizeTarget(target);
        return sanitizedTarget.trim().split("\\s+");
    }

    private void parseCoordinates(String target, TargetData targetData) throws PositionParserException {
        try {
            boolean parsedRadius;
            Range<Double> range2;
            boolean parsed = false;
            String[] parts = this.partition(target);
            if (parts.length > 0 && parts[0] != null) {
                try {
                    range2 = this.getRARange(parts[0]);
                    targetData.setRaRange(range2);
                }
                catch (RangeParserException range2) {
                    // empty catch block
                }
                if (targetData.getRaRange() == null) {
                    targetData.setRA(this.raToDegrees(parts[0].trim()));
                }
            }
            if (parts.length > 1 && parts[1] != null) {
                try {
                    range2 = this.getDecRange(parts[1]);
                    targetData.setDecRange(range2);
                }
                catch (RangeParserException range3) {
                    // empty catch block
                }
                if (targetData.getDecRange() == null) {
                    targetData.setDec(this.decToDegrees(parts[1].trim()));
                }
                parsed = true;
            }
            if (parts.length > 2 && parts[2] != null && !(parsedRadius = this.parseRadius(parts[2], targetData))) {
                this.parseCoordsys(parts[2], targetData);
            }
            if (parts.length > 3 && parts[3] != null) {
                parsed = this.parseCoordsys(parts[3], targetData);
            }
            if (parts.length > 5 && parts[4] != null && parts[5] != null) {
                StringBuilder RA = new StringBuilder();
                StringBuilder DEC = new StringBuilder();
                try {
                    for (int i = 0; i < 6; ++i) {
                        String nextPart = parts[i];
                        if (!StringUtil.hasText((String)nextPart)) continue;
                        double d = Double.valueOf(nextPart);
                        if (i < 3) {
                            RA.append(d).append(":");
                            continue;
                        }
                        DEC.append(d).append(":");
                    }
                    targetData.setRA(this.raToDegrees(RA.toString()));
                    targetData.setDec(this.decToDegrees(DEC.toString()));
                    targetData.setRadius(0.0166667);
                    parsed = true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (parsed && parts.length > 6 && parts[6] != null && !(parsed = this.parseRadius(parts[6], targetData))) {
                parsed = this.parseCoordsys(parts[6], targetData);
            }
            if (parsed && parts.length > 7 && parts[7] != null) {
                parsed = this.parseCoordsys(parts[7], targetData);
            }
            if (!parsed) {
                throw new PositionParserException("Unable to parse: " + target);
            }
        }
        catch (NumberFormatException nfe) {
            String message = "Unable to parse '" + target + "' because " + nfe.getMessage();
            throw new PositionParserException(message);
        }
    }

    boolean parseRadius(String radius, TargetData targetData) {
        try {
            boolean parseSuccessful;
            RadiusParser radiusParser = new RadiusParser(radius.trim());
            boolean bl = parseSuccessful = radiusParser.getValue() != null;
            if (parseSuccessful) {
                targetData.setRadius(radiusParser.getValue().doubleValue());
            }
            return parseSuccessful;
        }
        catch (NumericParserException e) {
            log.debug((Object)("Parsing error for radius " + radius + "\n" + e.getMessage()));
            return false;
        }
    }

    private boolean parseCoordsys(String coordsys, TargetData targetData) {
        boolean success;
        CaseInsensitiveStringComparator comparator = new CaseInsensitiveStringComparator();
        String value = coordsys.trim();
        if (comparator.compare(value, CoordSys.ICRS.getValue()) == 0 || comparator.compare(value, CoordSys.FK5.getValue()) == 0 || comparator.compare(value, CoordSys.J2000.getValue()) == 0 || comparator.compare(value, CoordSys.J2000_0.getValue()) == 0) {
            targetData.setCoordsys(value);
            success = true;
        } else if (comparator.compare(value, CoordSys.GAL.getValue()) == 0) {
            if (targetData.getRA() != null && targetData.getDec() != null) {
                Point2D.Double point = new Point2D.Double(targetData.getRA(), targetData.getDec());
                point = wcscon.gal2fk5((Point2D.Double)point);
                targetData.setRA(point.x);
                targetData.setDec(point.y);
            }
            targetData.setCoordsys(value);
            success = true;
        } else if (comparator.compare(value, CoordSys.B1950.getValue()) == 0 || comparator.compare(value, CoordSys.B1950_0.getValue()) == 0 || comparator.compare(value, CoordSys.FK4.getValue()) == 0) {
            if (targetData.getRA() != null && targetData.getDec() != null) {
                Point2D.Double point = new Point2D.Double(targetData.getRA(), targetData.getDec());
                point = wcscon.fk425((Point2D.Double)point);
                targetData.setRA(point.x);
                targetData.setDec(point.y);
            }
            targetData.setCoordsys(value);
            success = true;
        } else {
            success = false;
        }
        return success;
    }

    protected Range<Double> getRARange(String query) throws RangeParserException {
        RangeParser rangeParser = new RangeParser(query, null);
        Range<String> sRange = rangeParser.parse();
        Double value = this.parseRA(sRange.getValue());
        Double lower = this.parseRA(sRange.getLowerValue());
        Double upper = this.parseRA(sRange.getUpperValue());
        return new Range<Double>(sRange.getRange(), value, lower, upper, sRange.getOperand());
    }

    protected Double parseRA(String query) {
        Double ra;
        if (query == null || query.isEmpty()) {
            return null;
        }
        try {
            ra = Double.valueOf(query);
        }
        catch (NumberFormatException ignore) {
            ra = this.raToDegrees(query);
        }
        return ra;
    }

    protected Range<Double> getDecRange(String query) throws RangeParserException {
        RangeParser rangeParser = new RangeParser(query, null);
        Range<String> sRange = rangeParser.parse();
        Double value = this.parseDec(sRange.getValue());
        Double lower = this.parseDec(sRange.getLowerValue());
        Double upper = this.parseDec(sRange.getUpperValue());
        return new Range<Double>(sRange.getRange(), value, lower, upper, sRange.getOperand());
    }

    protected Double parseDec(String query) {
        Double dec;
        if (query == null || query.isEmpty()) {
            return null;
        }
        try {
            dec = Double.valueOf(query);
        }
        catch (NumberFormatException ignore) {
            dec = this.decToDegrees(query);
        }
        return dec;
    }

    protected abstract Double raToDegrees(String var1);

    protected abstract Double decToDegrees(String var1);
}

