/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.search.parser;

import ca.nrc.cadc.search.parser.exception.DateParserException;
import ca.nrc.cadc.util.StringUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class DateParser {
    private static Logger LOGGER = Logger.getLogger(DateParser.class);
    public static Double MIN_YEAR = 1900.0;
    public static Double MAX_YEAR = 2100.0;
    public static Double MIN_JD = 2415020.5;
    public static Double MAX_JD = 2488069.5;
    public static Double MIN_MJD = 15020.0;
    public static Double MAX_MJD = 88069.0;
    public static Double MJD_DIFFERENTIAL = 2400000.5;
    public static Integer MIN_HOUR = 0;
    public static Integer MAX_HOUR = 23;
    public static String ISO_SEPARATER_REGEX = "[\\sT]+";
    public static String DATE_SEPARATER = "[-]";
    public static String TIME_SEPARATER = "[:.]";
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private Date date;
    private Calendar calendar;
    private boolean calendarIsJD;
    private int lastParsedField = 1;

    public DateParser(String query) throws DateParserException {
        if (!StringUtil.hasText((String)query)) {
            throw new DateParserException("Given String is empty.");
        }
        this.parse(query);
    }

    public boolean isJulianDate() {
        return this.calendarIsJD;
    }

    private void parse(String query) throws DateParserException {
        LOGGER.debug((Object)("parse: " + query));
        String[] tokens = query.split(ISO_SEPARATER_REGEX);
        if (tokens.length == 1) {
            this.parseOneToken(query, new String[]{query});
        } else if (tokens.length == 2) {
            this.parseTwoTokens(query, tokens);
        } else {
            throw new DateParserException("Unable to parse given input.");
        }
        this.normalize();
        this.date = this.calendar.getTime();
    }

    protected void parseOneToken(String query, String[] tokens) throws DateParserException {
        if (tokens[0] == null || tokens[0].trim().length() == 0) {
            throw new DateParserException("Null or zero length string");
        }
        this.calendar = this.parseMJD(tokens[0]);
        if (this.calendar != null) {
            this.calendarIsJD = true;
        } else {
            this.calendar = this.parseJD(tokens[0]);
        }
        if (this.calendar != null) {
            this.calendarIsJD = true;
        } else {
            this.calendar = this.parseDateAndTime(tokens[0]);
        }
        if (this.calendarIsJD) {
            int decimals;
            int dot = tokens[0].indexOf(".");
            this.lastParsedField = dot == -1 ? 5 : ((decimals = tokens[0].length() - (dot + 1)) >= 3 ? 12 : (decimals >= 1 ? 11 : 5));
        }
        if (this.calendar == null) {
            throw new DateParserException("Unable to parse " + query);
        }
    }

    protected void parseTwoTokens(String query, String[] tokens) throws DateParserException {
        this.calendar = this.parseMJD(tokens[0]);
        if (this.calendar != null) {
            this.calendarIsJD = true;
        } else {
            this.calendar = this.parseJD(tokens[0]);
        }
        if (this.calendar != null) {
            this.calendarIsJD = true;
        } else {
            Calendar startTime;
            this.calendar = this.parseDate(tokens[0]);
            if (this.calendar != null && (startTime = this.parseTime(tokens[1])) != null) {
                this.setDateTime(this.calendar, startTime);
                return;
            }
        }
        if (this.calendar == null) {
            this.calendar = this.parseDateAndTime(tokens[0]);
        }
        if (this.calendar == null) {
            throw new DateParserException("Unable to parse " + query);
        }
    }

    protected void normalize() {
        LOGGER.debug((Object)("normalize date[" + this.calToString(this.calendar) + "]"));
        if (!this.calendarIsJD) {
            LOGGER.debug((Object)("lastParsedStartField " + this.lastParsedField));
            if (this.lastParsedField < 14) {
                this.calendar.set(14, this.calendar.getActualMinimum(14));
            }
            if (this.lastParsedField < 13) {
                this.calendar.set(13, this.calendar.getActualMinimum(13));
            }
            if (this.lastParsedField < 12) {
                this.calendar.set(12, this.calendar.getActualMinimum(12));
            }
            if (this.lastParsedField < 11) {
                this.calendar.set(11, this.calendar.getActualMinimum(11));
            }
            if (this.lastParsedField < 5) {
                this.calendar.set(5, this.calendar.getActualMinimum(5));
            }
            if (this.lastParsedField < 2) {
                this.calendar.set(2, this.calendar.getActualMinimum(2));
            }
        }
        LOGGER.debug((Object)("date[" + this.calToString(this.calendar) + "]"));
    }

    private void setDateTime(Calendar date, Calendar time) {
        if (time.isSet(11)) {
            date.set(11, time.get(11));
        }
        if (time.isSet(12)) {
            date.set(12, time.get(12));
        }
        if (time.isSet(13)) {
            date.set(13, time.get(13));
        }
        if (time.isSet(14)) {
            date.set(14, time.get(14));
        }
    }

    private Calendar parseMJD(String s) {
        Double d = this.parseDouble(s);
        if (d == null) {
            LOGGER.debug((Object)("parseMJD[" + s + "] cannot parse as double"));
            return null;
        }
        if (d.compareTo(MIN_MJD) >= 0 && d.compareTo(MAX_MJD) <= 0) {
            LOGGER.debug((Object)("parseMJD[" + s + "] " + d));
            return DateParser.toCalendar(d);
        }
        LOGGER.debug((Object)("parseMJD[" + s + "] value out of range"));
        return null;
    }

    private Calendar parseJD(String s) {
        Double d = this.parseDouble(s);
        if (d == null) {
            LOGGER.debug((Object)("parseJD[" + s + "] cannot parse as double"));
            return null;
        }
        if (d.compareTo(MIN_JD) >= 0 && d.compareTo(MAX_JD) <= 0) {
            LOGGER.debug((Object)("parseJD[" + s + "] " + d));
            return DateParser.toCalendar(d - MJD_DIFFERENTIAL);
        }
        LOGGER.debug((Object)("parseJD[" + s + "] value out of range"));
        return null;
    }

    private Calendar parseDateAndTime(String s) {
        String[] tokens = s.split(ISO_SEPARATER_REGEX);
        Calendar cal = null;
        if (tokens.length == 1) {
            cal = this.parseDate(s);
        } else if (tokens.length == 2) {
            cal = this.parseDateTime(tokens[0], tokens[1]);
        }
        LOGGER.debug((Object)("parseDateAndTime[" + s + "] " + this.calToString(cal)));
        return cal;
    }

    private Calendar parseDateTime(String date, String time) {
        Calendar calTime;
        Calendar calDate = this.parseDate(date);
        if (calDate != null && (calTime = this.parseTime(time)) != null) {
            this.setDateTime(calDate, calTime);
        }
        LOGGER.debug((Object)("parseDateTime[" + date + "," + time + "] " + this.calToString(calDate)));
        return calDate;
    }

    private Calendar parseDate(String s) {
        if (s.length() != 0 && !Character.isDigit(s.charAt(0))) {
            LOGGER.debug((Object)("parseDate[" + s + "] invalid start to value"));
            return null;
        }
        String[] tokens = s.split(DATE_SEPARATER);
        Double year = null;
        Double month = null;
        Double day = null;
        if (tokens.length >= 1) {
            year = this.parseDouble(tokens[0]);
            if (year == null) {
                LOGGER.debug((Object)("parseDate[" + s + "] invalid year"));
                return null;
            }
            if (year.compareTo(MIN_YEAR) < 0 || year.compareTo(MAX_YEAR) > 0) {
                LOGGER.debug((Object)("parseDate[" + s + "] value of of range"));
                return null;
            }
            this.lastParsedField = 1;
        }
        if (tokens.length >= 2) {
            month = this.parseDouble(tokens[1]);
            if (month == null) {
                LOGGER.debug((Object)("parseDate[" + s + "] invalid month"));
                return null;
            }
            this.lastParsedField = 2;
        }
        if (tokens.length == 3) {
            day = this.parseDouble(tokens[2]);
            if (day == null) {
                LOGGER.debug((Object)("parseDate[" + s + "] invalid day"));
                return null;
            }
            this.lastParsedField = 5;
        }
        Calendar cal = null;
        if (year != null) {
            cal = Calendar.getInstance();
            cal.clear();
            cal.setTimeZone(UTC);
            cal.set(1, year.intValue());
            if (month != null) {
                cal.set(2, month.intValue() - 1);
                if (day != null) {
                    cal.set(5, day.intValue());
                }
            }
        }
        LOGGER.debug((Object)("parseDate[" + s + "] " + this.calToString(cal)));
        return cal;
    }

    private Calendar parseTime(String s) {
        String[] tokens = s.split(TIME_SEPARATER);
        Integer hour = null;
        Integer minute = null;
        Integer second = null;
        Integer milli = null;
        if (tokens.length >= 1) {
            hour = this.parseInteger(tokens[0]);
            if (hour == null) {
                LOGGER.debug((Object)("parseTime[" + s + "] invalid hour"));
                return null;
            }
            if (hour.compareTo(MIN_HOUR) < 0 || hour.compareTo(MAX_HOUR) > 0) {
                LOGGER.debug((Object)("parseTime[" + s + "] value out of range"));
                return null;
            }
            this.lastParsedField = 11;
        }
        if (tokens.length >= 2) {
            minute = this.parseInteger(tokens[1]);
            if (minute == null) {
                LOGGER.debug((Object)("parseTime[" + s + "] invalid minute"));
                return null;
            }
            this.lastParsedField = 12;
        }
        if (tokens.length >= 3) {
            second = this.parseInteger(tokens[2]);
            if (second == null) {
                LOGGER.debug((Object)("parseTime[" + s + "] invalid second"));
                return null;
            }
            this.lastParsedField = 13;
        }
        if (tokens.length == 4) {
            milli = this.parseInteger(tokens[3]);
            if (milli == null) {
                LOGGER.debug((Object)("parseTime[" + s + "] invalid milli"));
                return null;
            }
            this.lastParsedField = 14;
        }
        Calendar cal = null;
        if (hour != null) {
            cal = Calendar.getInstance();
            cal.clear();
            cal.setTimeZone(UTC);
            cal.set(11, hour);
            if (minute != null) {
                cal.set(12, minute);
                if (second != null) {
                    cal.set(13, second);
                    if (milli != null) {
                        cal.set(14, milli);
                    }
                }
            }
        }
        LOGGER.debug((Object)("parseTime[" + s + "] " + this.calToString(cal)));
        return cal;
    }

    private Integer parseInteger(String s) {
        try {
            return new Integer(s);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private Double parseDouble(String s) {
        try {
            return new Double(s);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private String calToString(Calendar cal) {
        if (cal == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(cal.get(1));
        sb.append("-");
        sb.append(cal.get(2) + 1);
        sb.append("-");
        sb.append(cal.get(5));
        sb.append("T");
        sb.append(cal.get(11));
        sb.append(":");
        sb.append(cal.get(12));
        sb.append(":");
        sb.append(cal.get(13));
        sb.append(".");
        sb.append(cal.get(14));
        return sb.toString();
    }

    public static Calendar toCalendar(double mjd) {
        int[] ymd = DateParser.slaDjcl(mjd);
        double frac = mjd - (double)((long)mjd);
        int hh = (int)(frac * 24.0);
        frac = frac * 24.0 - (double)hh;
        int mm = (int)(frac * 60.0);
        frac = frac * 60.0 - (double)mm;
        int ss = (int)(frac * 60.0);
        frac = frac * 60.0 - (double)ss;
        int ms = (int)(frac * 1000.0);
        Calendar cal = Calendar.getInstance(UTC);
        cal.set(1, ymd[0]);
        cal.set(2, ymd[1] - 1);
        cal.set(5, ymd[2]);
        cal.set(11, hh);
        cal.set(12, mm);
        cal.set(13, ss);
        cal.set(14, ms);
        return cal;
    }

    private static int[] slaDjcl(double djm) {
        if (djm <= -2395520.0 || djm >= 1.0E9) {
            throw new IllegalArgumentException("MJD out of valid range");
        }
        long ld = (long)djm;
        long jd = ld + 2400001L;
        long n4 = 4L * (jd + (6L * ((4L * jd - 17918L) / 146097L) / 4L + 1L) / 2L - 37L);
        long nd10 = 10L * ((n4 - 237L) % 1461L / 4L) + 5L;
        int[] ret = new int[]{(int)(n4 / 1461L - 4712L), (int)((nd10 / 306L + 2L) % 12L + 1L), (int)(nd10 % 306L / 10L + 1L)};
        return ret;
    }

    public Date getDate() {
        return this.date;
    }

    public int getLastParsedField() {
        return this.lastParsedField;
    }
}

