/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.search.parser;

import ca.nrc.cadc.search.parser.AbstractNumericParser;
import ca.nrc.cadc.search.parser.NumberParser;
import ca.nrc.cadc.search.parser.Numeric;
import ca.nrc.cadc.search.parser.exception.EnergyParserException;
import ca.nrc.cadc.search.parser.exception.NumericParserException;
import ca.nrc.cadc.util.StringUtil;
import org.apache.log4j.Logger;

public class EnergyParser
extends AbstractNumericParser {
    private static Logger LOGGER = Logger.getLogger(EnergyParser.class);

    public EnergyParser(String val) throws NumericParserException {
        super(val);
    }

    public EnergyParser() {
    }

    @Override
    public void parse() throws NumericParserException {
        Numeric numeric;
        NumberParser numberParser;
        String query = this.getSource();
        LOGGER.debug((Object)("parse: " + query));
        if (!StringUtil.hasText((String)query)) {
            throw new EnergyParserException("Given String is empty.");
        }
        Numeric energy = new Numeric();
        String[] tokens = query.split(QUERY_SEPARATER_REGEX);
        if (tokens.length == 0 || tokens.length > 3) {
            throw new EnergyParserException("Invalid number of arguments to parse: " + tokens.length);
        }
        if (tokens.length >= 1) {
            numberParser = new NumberParser(tokens[0]);
            numeric = numberParser.getResult();
            if (numeric.value == null) {
                throw new EnergyParserException("Unable to parse query " + query);
            }
            energy.value = numeric.value;
            energy.unit = numeric.unit;
        }
        if (tokens.length >= 2) {
            numberParser = new NumberParser(tokens[1]);
            numeric = numberParser.getResult();
            if (!StringUtil.hasText((String)energy.unit)) {
                if (numeric.unit == null) {
                    throw new EnergyParserException("Unable to parse query for units in " + query);
                }
                energy.unit = numeric.unit;
            } else {
                if (numeric.value == null) {
                    throw new EnergyParserException("Unable to parse query for tolerance in " + query);
                }
                energy.tolerance = numeric.value;
            }
        }
        if (tokens.length >= 3) {
            if (energy.tolerance != null) {
                throw new EnergyParserException("Unable to parse query for tolerance in " + query);
            }
            numberParser = new NumberParser(tokens[2]);
            numeric = numberParser.getResult();
            if (numeric.value == null) {
                throw new EnergyParserException("Unable to parse query for tolerance in " + query);
            }
            energy.tolerance = numeric.value;
        }
        if (energy.value == null) {
            throw new EnergyParserException("Unable to parse query " + query);
        }
        this.setResult(energy);
        LOGGER.debug((Object)energy);
    }
}

