/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.search.parser;

import ca.nrc.cadc.search.parser.AbstractNumericParser;
import ca.nrc.cadc.search.parser.Numeric;
import ca.nrc.cadc.search.parser.exception.NumericParserException;
import ca.nrc.cadc.util.StringUtil;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;

public class RadiusParser
extends AbstractNumericParser {
    private static final Logger LOGGER = Logger.getLogger(RadiusParser.class);
    private static final double MAX_RADIUS = 90.0;
    private String radiusFormat;

    public RadiusParser(String val) throws NumericParserException {
        super(val);
    }

    @Override
    public void parse() throws NumericParserException {
        Numeric result = new Numeric();
        String rad = this.getSource();
        if (StringUtil.hasText((String)rad)) {
            try {
                Double radiusValue = this.parseDouble();
                String radiusUnit = this.parseUnit();
                if (!StringUtil.hasText((String)radiusUnit) || radiusUnit.matches("^[dD]+[eE]?[gG]?.*$")) {
                    LOGGER.debug((Object)("parseRadius: " + rad + " looks like a number in degrees"));
                    result.value = radiusValue;
                } else if (radiusUnit.matches("\"|''|^[aA]+[rR]?[cC]?[sS]+.*$")) {
                    LOGGER.debug((Object)("parseRadius: " + rad + " looks like a number in arcsec"));
                    result.value = radiusValue / 3600.0;
                    this.setRadiusFormat(this.buildNumberFormat(radiusUnit, 6));
                } else if (radiusUnit.matches("'|^[aA]+[rR]?[cC]?[mM]+.*$")) {
                    LOGGER.debug((Object)("parseRadius: " + rad + " looks like a number in arcmin"));
                    result.value = radiusValue / 60.0;
                    this.setRadiusFormat(this.buildNumberFormat(radiusUnit, 4));
                }
                LOGGER.debug((Object)("parseRadius: " + rad + " did not match any pattern/expectations"));
            }
            catch (PatternSyntaxException pse) {
                LOGGER.debug((Object)("Pattern syntax error for radius " + rad + pse.getMessage()));
            }
            catch (NumberFormatException nfe) {
                LOGGER.debug((Object)("Parsing error for radius " + rad + nfe.getMessage()));
            }
        }
        if (result.value != null && Double.compare(result.value.doubleValue(), 90.0) > 0) {
            throw new NumericParserException("Radius is out of range.");
        }
        this.setResult(result);
    }

    private String buildNumberFormat(String s, int pad) {
        int len;
        int decimals = pad;
        StringBuilder format = new StringBuilder("##0");
        int index = s.indexOf(46);
        if (index != -1 && (len = s.length()) > index + 1) {
            decimals += len - (index + 1);
        }
        if (decimals > 0) {
            format.append(".");
        }
        for (int i = 0; i < decimals; ++i) {
            format.append("0");
        }
        return format.toString();
    }

    public String getRadiusFormat() {
        return this.radiusFormat;
    }

    private void setRadiusFormat(String radiusFormat) {
        this.radiusFormat = radiusFormat;
    }
}

