/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.search.parser;

import ca.nrc.cadc.search.parser.Operand;
import ca.nrc.cadc.search.parser.Range;
import ca.nrc.cadc.search.parser.exception.RangeParserException;
import ca.nrc.cadc.util.StringUtil;

public class RangeParser {
    private final String rangeValue;
    private Operand operand;

    public RangeParser(String _rangeValue, Operand _operand) {
        this.rangeValue = _rangeValue;
        this.operand = _operand;
    }

    public Range<String> parse() throws RangeParserException {
        Operand op;
        String currRangeValue = this.getRangeValue();
        if (!StringUtil.hasText((String)currRangeValue)) {
            String message = "null or empty range";
            throw new RangeParserException("null or empty range");
        }
        Operand operand = op = this.getOperand() == null ? this.parseOperand() : this.getOperand();
        if (op == null) {
            String message = "Unable to parse operand from range " + currRangeValue;
            throw new RangeParserException(message);
        }
        String value = null;
        String lower = null;
        String upper = null;
        String operandValue = op.getOperand();
        int index = currRangeValue.lastIndexOf(operandValue);
        if (index == -1) {
            String message = "operand " + operandValue + " not found in range " + currRangeValue;
            throw new RangeParserException(message);
        }
        if (op == Operand.RANGE) {
            lower = currRangeValue.substring(0, index).trim();
            upper = currRangeValue.substring(index + operandValue.length()).trim();
        } else if (op.getOperand().startsWith(Operand.LESS_THAN.getOperand())) {
            upper = currRangeValue.substring(index + operandValue.length()).trim();
        } else if (op.getOperand().startsWith(Operand.GREATER_THAN.getOperand())) {
            lower = currRangeValue.substring(index + operandValue.length()).trim();
        } else if (op == Operand.EQUALS) {
            value = currRangeValue.substring(index + operandValue.length()).trim();
        }
        if (value == null && lower == null && upper == null) {
            String message = "Unable to parse range " + currRangeValue;
            throw new RangeParserException(message);
        }
        return new Range<String>(currRangeValue, value, lower, upper, op);
    }

    public Range<Double> parseDouble() throws RangeParserException {
        Double upper;
        Double lower;
        Double value;
        Range<String> sRange = this.parse();
        try {
            value = sRange.getValue() == null ? null : Double.valueOf(sRange.getValue());
            lower = sRange.getLowerValue() == null ? null : Double.valueOf(sRange.getLowerValue());
            upper = sRange.getUpperValue() == null ? null : Double.valueOf(sRange.getUpperValue());
        }
        catch (NumberFormatException e) {
            String message = "Unable to parse range from " + this.getRangeValue() + " because " + e.getMessage();
            throw new RangeParserException(message);
        }
        return new Range<Double>(this.getRangeValue(), value, lower, upper, sRange.getOperand());
    }

    public static String trimRange(String value) {
        if (!StringUtil.hasText((String)value)) {
            return value;
        }
        int fromIndex = 0;
        int index = value.indexOf(Operand.RANGE.getOperand(), fromIndex);
        if (index == -1) {
            return value;
        }
        StringBuilder sb = new StringBuilder();
        if (value.charAt(index - 1) == ' ') {
            sb.append(value.substring(0, index - 1));
        } else {
            sb.append(value.substring(0, index));
        }
        sb.append(Operand.RANGE.getOperand());
        fromIndex = index + 2;
        if (value.charAt(index + Operand.RANGE.getOperand().length()) == ' ') {
            ++fromIndex;
        }
        if ((index = value.indexOf(Operand.RANGE.getOperand(), fromIndex)) != -1) {
            if (value.charAt(index - 1) == ' ') {
                sb.append(value.substring(0, index - 1));
            } else {
                sb.append(value.substring(0, index));
            }
            sb.append(Operand.RANGE.getOperand());
            fromIndex = index + 2;
            if (value.charAt(index + 3) == ' ') {
                ++fromIndex;
            }
            sb.append(value.substring(fromIndex));
        }
        sb.append(value.substring(fromIndex));
        return sb.toString();
    }

    protected Operand parseOperand() {
        String range = this.getRangeValue();
        Operand op = !StringUtil.hasText((String)range) ? null : (range.contains(Operand.RANGE.getOperand()) ? Operand.RANGE : (range.startsWith(Operand.LESS_THAN_EQUALS.getOperand()) ? Operand.LESS_THAN_EQUALS : (range.startsWith(Operand.GREATER_THAN_EQUALS.getOperand()) ? Operand.GREATER_THAN_EQUALS : (range.startsWith(Operand.LESS_THAN.getOperand()) ? Operand.LESS_THAN : (range.startsWith(Operand.GREATER_THAN.getOperand()) ? Operand.GREATER_THAN : (range.startsWith(Operand.EQUALS.getOperand()) ? Operand.EQUALS : null))))));
        return op;
    }

    public String getRangeValue() {
        return this.rangeValue;
    }

    public Operand getOperand() {
        return this.operand;
    }

    protected void setOperand(Operand _operand) {
        this.operand = _operand;
    }
}

