/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.search.parser;

import ca.nrc.cadc.search.parser.PositionParser;
import ca.nrc.cadc.search.parser.Resolver;
import ca.nrc.cadc.search.parser.TargetData;
import ca.nrc.cadc.search.parser.exception.PositionParserException;
import ca.nrc.cadc.search.parser.exception.TargetParserException;
import ca.nrc.cadc.util.StringUtil;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class TargetParser {
    private static final Logger log = Logger.getLogger(TargetParser.class);
    private static final String DEGREE_SYMBOL = Character.toString('\u00b0');
    private static final String RA_DEC_SEPARATORS = "'\"dhmsDHMS:" + DEGREE_SYMBOL;
    private final Resolver resolver;

    public TargetParser(Resolver resolver) {
        this.resolver = resolver;
    }

    public TargetData parse(String target, String resolver) throws TargetParserException {
        if (!StringUtil.hasText((String)target)) {
            throw new TargetParserException("Null or empty target");
        }
        if (!StringUtil.hasText((String)resolver)) {
            throw new TargetParserException("Null or empty resolver");
        }
        return this.parseTarget(target, resolver);
    }

    protected String sanitizeTarget(String target) {
        return target.replace(",", "").replaceAll("(\\s*)(\\.{2,})(\\s*)", "$2");
    }

    public boolean isQueryInDegrees(String query) {
        StringTokenizer st;
        String s;
        boolean raIsDegrees = true;
        boolean decIsDegrees = true;
        String temp = this.sanitizeTarget(query);
        String[] parts = temp.trim().split("\\s+");
        if (parts.length > 4) {
            return false;
        }
        if (parts.length > 0 && parts[0] != null) {
            s = parts[0].trim();
            st = new StringTokenizer(s, RA_DEC_SEPARATORS, true);
            boolean bl = raIsDegrees = st.countTokens() == 1;
        }
        if (parts.length > 1 && parts[1] != null) {
            s = parts[1].trim();
            st = new StringTokenizer(s, RA_DEC_SEPARATORS, true);
            decIsDegrees = st.countTokens() == 1;
        }
        return raIsDegrees || decIsDegrees;
    }

    TargetData parseTarget(String target, String resolverName) throws TargetParserException {
        TargetData targetData;
        PositionParser parser = new PositionParser();
        log.debug((Object)("parse: " + target));
        try {
            targetData = parser.parse(target);
            log.debug((Object)parser);
        }
        catch (PositionParserException e) {
            try {
                String lowerResolvedTarget;
                String lowerTarget;
                targetData = this.resolver.resolveTarget(target, resolverName);
                if (targetData == null) {
                    throw new TargetParserException("Unable to resolve: " + target, e, TargetParserException.ExceptionType.NAMERESOLVER_TARGET_NOT_FOUND);
                }
                String resolvedTarget = targetData.getTarget();
                String targetRadiusCheck = StringUtil.hasText((String)resolvedTarget) ? ((lowerTarget = target.toLowerCase()).contains(lowerResolvedTarget = resolvedTarget.toLowerCase()) ? lowerTarget.substring(lowerResolvedTarget.length()) : target) : target;
                String[] parts = parser.partition(targetRadiusCheck);
                parser.parseRadius(parts[parts.length - 1], targetData);
            }
            catch (IOException re) {
                throw new TargetParserException(String.format("Unable to resolve %s", target));
            }
        }
        catch (IllegalArgumentException iae) {
            throw new TargetParserException("Illegal argument for target " + iae.getMessage());
        }
        return targetData;
    }
}

