/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.search.parser;

import ca.nrc.cadc.search.parser.AbstractNumericParser;
import ca.nrc.cadc.search.parser.NumberParser;
import ca.nrc.cadc.search.parser.Numeric;
import ca.nrc.cadc.search.parser.exception.NumericParserException;
import ca.nrc.cadc.search.parser.exception.TimeParserException;
import ca.nrc.cadc.util.StringUtil;
import org.apache.log4j.Logger;

public class TimeParser
extends AbstractNumericParser {
    private static Logger LOGGER = Logger.getLogger(TimeParser.class);

    public TimeParser(String val) throws NumericParserException {
        super(val);
    }

    public TimeParser() {
    }

    @Override
    public void parse() throws NumericParserException {
        NumberParser numberParser;
        String query = this.getSource();
        LOGGER.debug((Object)("parse: " + query));
        if (!StringUtil.hasText((String)query)) {
            throw new TimeParserException("Given String is empty.");
        }
        Numeric time = new Numeric();
        String[] tokens = query.split(QUERY_SEPARATER_REGEX);
        if (tokens.length == 0 || tokens.length > 2) {
            throw new TimeParserException("Invalid number of arguments to parse: " + tokens.length);
        }
        if (tokens.length >= 1) {
            numberParser = new NumberParser(tokens[0]);
            if (numberParser.getValue() == null) {
                throw new TimeParserException("Unable to parse query " + query);
            }
            time.value = numberParser.getValue();
            time.unit = numberParser.getUnit();
        }
        if (tokens.length >= 2) {
            if (!StringUtil.hasText((String)time.unit)) {
                numberParser = new NumberParser(tokens[1]);
                if (numberParser.getUnit() == null || numberParser.getValue() != null) {
                    throw new TimeParserException("Unable to parse query for units in " + query);
                }
                time.unit = numberParser.getUnit();
            } else {
                throw new TimeParserException("Unable to parse query " + query);
            }
        }
        if (time.value == null) {
            throw new TimeParserException("Unable to parse query " + query);
        }
        this.setResult(time);
        LOGGER.debug((Object)time);
    }
}

