/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.search.parser.resolver;

import ca.nrc.cadc.search.nameresolver.NameResolver;
import ca.nrc.cadc.search.nameresolver.NameResolverData;
import ca.nrc.cadc.search.nameresolver.NameResolverException;
import ca.nrc.cadc.search.nameresolver.exception.TargetNotFoundException;
import ca.nrc.cadc.search.parser.RadiusParser;
import ca.nrc.cadc.search.parser.Resolver;
import ca.nrc.cadc.search.parser.TargetData;
import ca.nrc.cadc.search.parser.exception.NumericParserException;
import ca.nrc.cadc.util.StringUtil;
import java.io.IOException;
import java.util.Arrays;

public class ResolverImpl
implements Resolver {
    private final NameResolver nameResolverClient;

    public ResolverImpl(NameResolver nameResolverClient) {
        this.nameResolverClient = nameResolverClient;
    }

    public ResolverImpl() {
        this(new NameResolver());
    }

    private Double parseRadius(String rad) {
        Double val;
        try {
            RadiusParser parser = new RadiusParser(rad);
            val = parser.getValue().doubleValue();
        }
        catch (NumericParserException e) {
            val = null;
        }
        return val;
    }

    @Override
    public TargetData resolveTarget(String target, String resolverName) throws IOException {
        TargetData result;
        if (StringUtil.hasLength((String)target) && StringUtil.hasLength((String)resolverName)) {
            result = this.resolve(target, resolverName);
            if (result == null) {
                String[] parts = target.split("[, ]+");
                if (parts.length > 1) {
                    String rad = parts[parts.length - 1];
                    Double radius = this.parseRadius(rad);
                    if (radius == null) {
                        result = null;
                    } else {
                        StringBuilder targetValueBuilder = new StringBuilder();
                        for (String targetVal : Arrays.copyOfRange(parts, 0, parts.length - 1)) {
                            targetValueBuilder.append(targetVal).append(" ");
                        }
                        String name = targetValueBuilder.toString().trim();
                        char c = name.charAt(name.length() - 1);
                        while (c == ',' || c == ' ') {
                            name = name.substring(0, name.length() - 1);
                            c = name.charAt(name.length() - 1);
                        }
                        result = this.resolveTarget(name, resolverName);
                        if (result != null) {
                            result.setRadius(radius);
                        }
                    }
                } else {
                    result = null;
                }
            }
        } else {
            throw new IllegalArgumentException("Target and Resolver name are required.");
        }
        return result;
    }

    private TargetData resolve(String target, String resolverName) throws IOException {
        try {
            NameResolverData data = this.nameResolverClient.resolve(target, resolverName, false, true);
            return new TargetData(data.getTarget(), data.getRa(), null, data.getDec(), null, null, data.getCoordsys(), data.getService(), data.getTime(), data.getObjectName(), data.getObjectType(), data.getMorphologyType());
        }
        catch (TargetNotFoundException tnfe) {
            return null;
        }
        catch (NameResolverException e) {
            throw new IOException(e.getMessage());
        }
    }
}

