/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.search.upload;

import ca.nrc.cadc.dali.Circle;
import ca.nrc.cadc.dali.Point;
import ca.nrc.cadc.dali.util.CircleFormat;
import ca.nrc.cadc.search.parser.TargetData;
import ca.nrc.cadc.search.parser.TargetParser;
import ca.nrc.cadc.search.parser.resolver.ResolverImpl;
import ca.nrc.cadc.search.upload.UploadResults;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class StreamingIterator
implements Iterator<Element> {
    private final Iterator<String> innerIterator;
    private final Namespace namespace;
    private final UploadResults uploadResults;
    private final CircleFormat cf = new CircleFormat();

    public StreamingIterator(Iterator<String> innerIterator, Namespace namespace, UploadResults uploadResults) {
        this.innerIterator = innerIterator;
        this.namespace = namespace;
        this.uploadResults = uploadResults;
    }

    @Override
    public boolean hasNext() {
        return this.innerIterator.hasNext();
    }

    @Override
    public Element next() throws NoSuchElementException {
        String line = this.innerIterator.next();
        this.uploadResults.incrementRowCount();
        Element tableRow = new Element("TR", this.namespace);
        tableRow.addContent((Content)this.createTableData(this.uploadResults.getRowCount()));
        tableRow.addContent((Content)this.createTableData(line));
        Double ra = null;
        Double dec = null;
        Double radius = null;
        Circle position = null;
        String error = "";
        try {
            ResolverImpl resolver = new ResolverImpl();
            TargetParser parser = new TargetParser(resolver);
            TargetData result = parser.parse(line, this.uploadResults.getResolver());
            ra = result.getRA();
            dec = result.getDec();
            radius = result.getRadius();
            position = new Circle(new Point(ra.doubleValue(), dec.doubleValue()), radius.doubleValue());
        }
        catch (Throwable t) {
            this.uploadResults.incrementErrorCount();
            error = t.getMessage();
        }
        tableRow.addContent((Content)this.createTableData(ra));
        tableRow.addContent((Content)this.createTableData(dec));
        tableRow.addContent((Content)this.createTableData(radius));
        tableRow.addContent((Content)this.createTableData(position));
        tableRow.addContent((Content)this.createTableData(error));
        return tableRow;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private Element createTableData(int i) {
        Element element = new Element("TD", this.namespace);
        element.setText(String.valueOf(i));
        return element;
    }

    private Element createTableData(Double d) {
        Element element = new Element("TD", this.namespace);
        element.setText(d == null ? "" : d.toString());
        return element;
    }

    private Element createTableData(String s) {
        Element element = new Element("TD", this.namespace);
        element.setText(s == null ? "" : s);
        return element;
    }

    private Element createTableData(Circle s) {
        Element element = new Element("TD", this.namespace);
        element.setText(s == null ? "" : this.cf.format(s));
        return element;
    }
}

